/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.ModelIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibilityInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompatibilityInformation> {
    private static final SdkField<Integer> CLIENT_COMPATIBILITY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("clientCompatibilityVersion").getter(CompatibilityInformation.getter(CompatibilityInformation::clientCompatibilityVersion)).setter(CompatibilityInformation.setter(Builder::clientCompatibilityVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCompatibilityVersion").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_MODEL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedModelIds").getter(CompatibilityInformation.getter(CompatibilityInformation::supportedModelIds)).setter(CompatibilityInformation.setter(Builder::supportedModelIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedModelIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(CompatibilityInformation.getter(CompatibilityInformation::message)).setter(CompatibilityInformation.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_COMPATIBILITY_VERSION_FIELD, SUPPORTED_MODEL_IDS_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompatibilityInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer clientCompatibilityVersion;
    private final List<String> supportedModelIds;
    private final String message;

    private CompatibilityInformation(BuilderImpl builder) {
        this.clientCompatibilityVersion = builder.clientCompatibilityVersion;
        this.supportedModelIds = builder.supportedModelIds;
        this.message = builder.message;
    }

    public final Integer clientCompatibilityVersion() {
        return this.clientCompatibilityVersion;
    }

    public final boolean hasSupportedModelIds() {
        return this.supportedModelIds != null && !(this.supportedModelIds instanceof SdkAutoConstructList);
    }

    public final List<String> supportedModelIds() {
        return this.supportedModelIds;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCompatibilityVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedModelIds() ? this.supportedModelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibilityInformation)) {
            return false;
        }
        CompatibilityInformation other = (CompatibilityInformation)obj;
        return Objects.equals(this.clientCompatibilityVersion(), other.clientCompatibilityVersion()) && this.hasSupportedModelIds() == other.hasSupportedModelIds() && Objects.equals(this.supportedModelIds(), other.supportedModelIds()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"CompatibilityInformation").add("ClientCompatibilityVersion", (Object)this.clientCompatibilityVersion()).add("SupportedModelIds", this.hasSupportedModelIds() ? this.supportedModelIds() : null).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientCompatibilityVersion": {
                return Optional.ofNullable(clazz.cast(this.clientCompatibilityVersion()));
            }
            case "supportedModelIds": {
                return Optional.ofNullable(clazz.cast(this.supportedModelIds()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientCompatibilityVersion", CLIENT_COMPATIBILITY_VERSION_FIELD);
        map.put("supportedModelIds", SUPPORTED_MODEL_IDS_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompatibilityInformation, T> g) {
        return obj -> g.apply((CompatibilityInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer clientCompatibilityVersion;
        private List<String> supportedModelIds = DefaultSdkAutoConstructList.getInstance();
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibilityInformation model) {
            this.clientCompatibilityVersion(model.clientCompatibilityVersion);
            this.supportedModelIds(model.supportedModelIds);
            this.message(model.message);
        }

        public final Integer getClientCompatibilityVersion() {
            return this.clientCompatibilityVersion;
        }

        public final void setClientCompatibilityVersion(Integer clientCompatibilityVersion) {
            this.clientCompatibilityVersion = clientCompatibilityVersion;
        }

        @Override
        public final Builder clientCompatibilityVersion(Integer clientCompatibilityVersion) {
            this.clientCompatibilityVersion = clientCompatibilityVersion;
            return this;
        }

        public final Collection<String> getSupportedModelIds() {
            if (this.supportedModelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedModelIds;
        }

        public final void setSupportedModelIds(Collection<String> supportedModelIds) {
            this.supportedModelIds = ModelIdListCopier.copy(supportedModelIds);
        }

        @Override
        public final Builder supportedModelIds(Collection<String> supportedModelIds) {
            this.supportedModelIds = ModelIdListCopier.copy(supportedModelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedModelIds(String ... supportedModelIds) {
            this.supportedModelIds(Arrays.asList(supportedModelIds));
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public CompatibilityInformation build() {
            return new CompatibilityInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompatibilityInformation> {
        public Builder clientCompatibilityVersion(Integer var1);

        public Builder supportedModelIds(Collection<String> var1);

        public Builder supportedModelIds(String ... var1);

        public Builder message(String var1);
    }
}

