/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ActSummary;
import software.amazon.awssdk.services.novaact.model.ListActsRequest;
import software.amazon.awssdk.services.novaact.model.ListActsResponse;

public class ListActsIterable
implements SdkIterable<ListActsResponse> {
    private final NovaActClient client;
    private final ListActsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActsIterable(NovaActClient client, ListActsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActsResponseFetcher();
    }

    public Iterator<ListActsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActSummary> actSummaries() {
        Function<ListActsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actSummaries() != null) {
                return response.actSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActsResponseFetcher
    implements SyncPageFetcher<ListActsResponse> {
        private ListActsResponseFetcher() {
        }

        public boolean hasNextPage(ListActsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActsResponse nextPage(ListActsResponse previousPage) {
            if (previousPage == null) {
                return ListActsIterable.this.client.listActs(ListActsIterable.this.firstRequest);
            }
            return ListActsIterable.this.client.listActs((ListActsRequest)((Object)ListActsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

