/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.CallResult;
import software.amazon.awssdk.services.novaact.model.CallResultsCopier;
import software.amazon.awssdk.services.novaact.model.NovaActRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeActStepRequest
extends NovaActRequest
implements ToCopyableBuilder<Builder, InvokeActStepRequest> {
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(InvokeActStepRequest.getter(InvokeActStepRequest::workflowDefinitionName)).setter(InvokeActStepRequest.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunId").getter(InvokeActStepRequest.getter(InvokeActStepRequest::workflowRunId)).setter(InvokeActStepRequest.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowRunId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvokeActStepRequest.getter(InvokeActStepRequest::sessionId)).setter(InvokeActStepRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> ACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actId").getter(InvokeActStepRequest.getter(InvokeActStepRequest::actId)).setter(InvokeActStepRequest.setter(Builder::actId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("actId").build()}).build();
    private static final SdkField<List<CallResult>> CALL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("callResults").getter(InvokeActStepRequest.getter(InvokeActStepRequest::callResults)).setter(InvokeActStepRequest.setter(Builder::callResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CallResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREVIOUS_STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previousStepId").getter(InvokeActStepRequest.getter(InvokeActStepRequest::previousStepId)).setter(InvokeActStepRequest.setter(Builder::previousStepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousStepId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_NAME_FIELD, WORKFLOW_RUN_ID_FIELD, SESSION_ID_FIELD, ACT_ID_FIELD, CALL_RESULTS_FIELD, PREVIOUS_STEP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeActStepRequest.memberNameToFieldInitializer();
    private final String workflowDefinitionName;
    private final String workflowRunId;
    private final String sessionId;
    private final String actId;
    private final List<CallResult> callResults;
    private final String previousStepId;

    private InvokeActStepRequest(BuilderImpl builder) {
        super(builder);
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.workflowRunId = builder.workflowRunId;
        this.sessionId = builder.sessionId;
        this.actId = builder.actId;
        this.callResults = builder.callResults;
        this.previousStepId = builder.previousStepId;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String actId() {
        return this.actId;
    }

    public final boolean hasCallResults() {
        return this.callResults != null && !(this.callResults instanceof SdkAutoConstructList);
    }

    public final List<CallResult> callResults() {
        return this.callResults;
    }

    public final String previousStepId() {
        return this.previousStepId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallResults() ? this.callResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.previousStepId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeActStepRequest)) {
            return false;
        }
        InvokeActStepRequest other = (InvokeActStepRequest)((Object)obj);
        return Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.actId(), other.actId()) && this.hasCallResults() == other.hasCallResults() && Objects.equals(this.callResults(), other.callResults()) && Objects.equals(this.previousStepId(), other.previousStepId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeActStepRequest").add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("WorkflowRunId", (Object)this.workflowRunId()).add("SessionId", (Object)this.sessionId()).add("ActId", (Object)this.actId()).add("CallResults", this.hasCallResults() ? this.callResults() : null).add("PreviousStepId", (Object)this.previousStepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "workflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "actId": {
                return Optional.ofNullable(clazz.cast(this.actId()));
            }
            case "callResults": {
                return Optional.ofNullable(clazz.cast(this.callResults()));
            }
            case "previousStepId": {
                return Optional.ofNullable(clazz.cast(this.previousStepId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("workflowRunId", WORKFLOW_RUN_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("actId", ACT_ID_FIELD);
        map.put("callResults", CALL_RESULTS_FIELD);
        map.put("previousStepId", PREVIOUS_STEP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeActStepRequest, T> g) {
        return obj -> g.apply((InvokeActStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActRequest.BuilderImpl
    implements Builder {
        private String workflowDefinitionName;
        private String workflowRunId;
        private String sessionId;
        private String actId;
        private List<CallResult> callResults = DefaultSdkAutoConstructList.getInstance();
        private String previousStepId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeActStepRequest model) {
            super(model);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.workflowRunId(model.workflowRunId);
            this.sessionId(model.sessionId);
            this.actId(model.actId);
            this.callResults(model.callResults);
            this.previousStepId(model.previousStepId);
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActId() {
            return this.actId;
        }

        public final void setActId(String actId) {
            this.actId = actId;
        }

        @Override
        public final Builder actId(String actId) {
            this.actId = actId;
            return this;
        }

        public final List<CallResult.Builder> getCallResults() {
            List<CallResult.Builder> result = CallResultsCopier.copyToBuilder(this.callResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallResults(Collection<CallResult.BuilderImpl> callResults) {
            this.callResults = CallResultsCopier.copyFromBuilder(callResults);
        }

        @Override
        public final Builder callResults(Collection<CallResult> callResults) {
            this.callResults = CallResultsCopier.copy(callResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callResults(CallResult ... callResults) {
            this.callResults(Arrays.asList(callResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callResults(Consumer<CallResult.Builder> ... callResults) {
            this.callResults(Stream.of(callResults).map(c -> (CallResult)((CallResult.Builder)CallResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreviousStepId() {
            return this.previousStepId;
        }

        public final void setPreviousStepId(String previousStepId) {
            this.previousStepId = previousStepId;
        }

        @Override
        public final Builder previousStepId(String previousStepId) {
            this.previousStepId = previousStepId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeActStepRequest build() {
            return new InvokeActStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeActStepRequest> {
        public Builder workflowDefinitionName(String var1);

        public Builder workflowRunId(String var1);

        public Builder sessionId(String var1);

        public Builder actId(String var1);

        public Builder callResults(Collection<CallResult> var1);

        public Builder callResults(CallResult ... var1);

        public Builder callResults(Consumer<CallResult.Builder> ... var1);

        public Builder previousStepId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

