/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.services.novaact.model.WorkflowRunSummariesCopier;
import software.amazon.awssdk.services.novaact.model.WorkflowRunSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowRunsResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, ListWorkflowRunsResponse> {
    private static final SdkField<List<WorkflowRunSummary>> WORKFLOW_RUN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflowRunSummaries").getter(ListWorkflowRunsResponse.getter(ListWorkflowRunsResponse::workflowRunSummaries)).setter(ListWorkflowRunsResponse.setter(Builder::workflowRunSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowRunSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowRunsResponse.getter(ListWorkflowRunsResponse::nextToken)).setter(ListWorkflowRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_RUN_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkflowRunsResponse.memberNameToFieldInitializer();
    private final List<WorkflowRunSummary> workflowRunSummaries;
    private final String nextToken;

    private ListWorkflowRunsResponse(BuilderImpl builder) {
        super(builder);
        this.workflowRunSummaries = builder.workflowRunSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkflowRunSummaries() {
        return this.workflowRunSummaries != null && !(this.workflowRunSummaries instanceof SdkAutoConstructList);
    }

    public final List<WorkflowRunSummary> workflowRunSummaries() {
        return this.workflowRunSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowRunSummaries() ? this.workflowRunSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowRunsResponse)) {
            return false;
        }
        ListWorkflowRunsResponse other = (ListWorkflowRunsResponse)((Object)obj);
        return this.hasWorkflowRunSummaries() == other.hasWorkflowRunSummaries() && Objects.equals(this.workflowRunSummaries(), other.workflowRunSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowRunsResponse").add("WorkflowRunSummaries", this.hasWorkflowRunSummaries() ? this.workflowRunSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowRunSummaries": {
                return Optional.ofNullable(clazz.cast(this.workflowRunSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowRunSummaries", WORKFLOW_RUN_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowRunsResponse, T> g) {
        return obj -> g.apply((ListWorkflowRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private List<WorkflowRunSummary> workflowRunSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowRunsResponse model) {
            super(model);
            this.workflowRunSummaries(model.workflowRunSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<WorkflowRunSummary.Builder> getWorkflowRunSummaries() {
            List<WorkflowRunSummary.Builder> result = WorkflowRunSummariesCopier.copyToBuilder(this.workflowRunSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowRunSummaries(Collection<WorkflowRunSummary.BuilderImpl> workflowRunSummaries) {
            this.workflowRunSummaries = WorkflowRunSummariesCopier.copyFromBuilder(workflowRunSummaries);
        }

        @Override
        public final Builder workflowRunSummaries(Collection<WorkflowRunSummary> workflowRunSummaries) {
            this.workflowRunSummaries = WorkflowRunSummariesCopier.copy(workflowRunSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowRunSummaries(WorkflowRunSummary ... workflowRunSummaries) {
            this.workflowRunSummaries(Arrays.asList(workflowRunSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowRunSummaries(Consumer<WorkflowRunSummary.Builder> ... workflowRunSummaries) {
            this.workflowRunSummaries(Stream.of(workflowRunSummaries).map(c -> (WorkflowRunSummary)((WorkflowRunSummary.Builder)WorkflowRunSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowRunsResponse build() {
            return new ListWorkflowRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowRunsResponse> {
        public Builder workflowRunSummaries(Collection<WorkflowRunSummary> var1);

        public Builder workflowRunSummaries(WorkflowRunSummary ... var1);

        public Builder workflowRunSummaries(Consumer<WorkflowRunSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

