/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.AggregationDuration;
import software.amazon.awssdk.services.notifications.model.NotificationConfigurationStatus;
import software.amazon.awssdk.services.notifications.model.NotificationConfigurationSubtype;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNotificationConfigurationResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, GetNotificationConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::arn)).setter(GetNotificationConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::name)).setter(GetNotificationConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::description)).setter(GetNotificationConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::statusAsString)).setter(GetNotificationConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::creationTime)).setter(GetNotificationConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> AGGREGATION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationDuration").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::aggregationDurationAsString)).setter(GetNotificationConfigurationResponse.setter(Builder::aggregationDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtype").getter(GetNotificationConfigurationResponse.getter(GetNotificationConfigurationResponse::subtypeAsString)).setter(GetNotificationConfigurationResponse.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, AGGREGATION_DURATION_FIELD, SUBTYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNotificationConfigurationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String description;
    private final String status;
    private final Instant creationTime;
    private final String aggregationDuration;
    private final String subtype;

    private GetNotificationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.aggregationDuration = builder.aggregationDuration;
        this.subtype = builder.subtype;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final NotificationConfigurationStatus status() {
        return NotificationConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final AggregationDuration aggregationDuration() {
        return AggregationDuration.fromValue(this.aggregationDuration);
    }

    public final String aggregationDurationAsString() {
        return this.aggregationDuration;
    }

    public final NotificationConfigurationSubtype subtype() {
        return NotificationConfigurationSubtype.fromValue(this.subtype);
    }

    public final String subtypeAsString() {
        return this.subtype;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationConfigurationResponse)) {
            return false;
        }
        GetNotificationConfigurationResponse other = (GetNotificationConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.aggregationDurationAsString(), other.aggregationDurationAsString()) && Objects.equals(this.subtypeAsString(), other.subtypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetNotificationConfigurationResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("AggregationDuration", (Object)this.aggregationDurationAsString()).add("Subtype", (Object)this.subtypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "aggregationDuration": {
                return Optional.ofNullable(clazz.cast(this.aggregationDurationAsString()));
            }
            case "subtype": {
                return Optional.ofNullable(clazz.cast(this.subtypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("aggregationDuration", AGGREGATION_DURATION_FIELD);
        map.put("subtype", SUBTYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationConfigurationResponse, T> g) {
        return obj -> g.apply((GetNotificationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String status;
        private Instant creationTime;
        private String aggregationDuration;
        private String subtype;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.aggregationDuration(model.aggregationDuration);
            this.subtype(model.subtype);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAggregationDuration() {
            return this.aggregationDuration;
        }

        public final void setAggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
        }

        @Override
        public final Builder aggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        @Override
        public final Builder aggregationDuration(AggregationDuration aggregationDuration) {
            this.aggregationDuration(aggregationDuration == null ? null : aggregationDuration.toString());
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(NotificationConfigurationSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        @Override
        public GetNotificationConfigurationResponse build() {
            return new GetNotificationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNotificationConfigurationResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(NotificationConfigurationStatus var1);

        public Builder creationTime(Instant var1);

        public Builder aggregationDuration(String var1);

        public Builder aggregationDuration(AggregationDuration var1);

        public Builder subtype(String var1);

        public Builder subtype(NotificationConfigurationSubtype var1);
    }
}

