/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse;
import software.amazon.awssdk.services.notifications.model.NotificationHubOverview;

public class ListNotificationHubsIterable
implements SdkIterable<ListNotificationHubsResponse> {
    private final NotificationsClient client;
    private final ListNotificationHubsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationHubsIterable(NotificationsClient client, ListNotificationHubsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotificationHubsResponseFetcher();
    }

    public Iterator<ListNotificationHubsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationHubOverview> notificationHubs() {
        Function<ListNotificationHubsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationHubs() != null) {
                return response.notificationHubs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationHubsResponseFetcher
    implements SyncPageFetcher<ListNotificationHubsResponse> {
        private ListNotificationHubsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationHubsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationHubsResponse nextPage(ListNotificationHubsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationHubsIterable.this.client.listNotificationHubs(ListNotificationHubsIterable.this.firstRequest);
            }
            return ListNotificationHubsIterable.this.client.listNotificationHubs((ListNotificationHubsRequest)((Object)ListNotificationHubsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

