/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TextPartType {
    LOCALIZED_TEXT("LOCALIZED_TEXT"),
    PLAIN_TEXT("PLAIN_TEXT"),
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TextPartType> VALUE_MAP;
    private final String value;

    private TextPartType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextPartType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextPartType> knownValues() {
        EnumSet<TextPartType> knownValues = EnumSet.allOf(TextPartType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TextPartType.class, TextPartType::toString);
    }
}

