/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.Resource;
import software.amazon.awssdk.services.notifications.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceEventMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceEventMetadata> {
    private static final SdkField<String> EVENT_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeVersion").getter(SourceEventMetadata.getter(SourceEventMetadata::eventTypeVersion)).setter(SourceEventMetadata.setter(Builder::eventTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeVersion").build()}).build();
    private static final SdkField<String> SOURCE_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceEventId").getter(SourceEventMetadata.getter(SourceEventMetadata::sourceEventId)).setter(SourceEventMetadata.setter(Builder::sourceEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventId").build()}).build();
    private static final SdkField<String> EVENT_ORIGIN_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventOriginRegion").getter(SourceEventMetadata.getter(SourceEventMetadata::eventOriginRegion)).setter(SourceEventMetadata.setter(Builder::eventOriginRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventOriginRegion").build()}).build();
    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedAccount").getter(SourceEventMetadata.getter(SourceEventMetadata::relatedAccount)).setter(SourceEventMetadata.setter(Builder::relatedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(SourceEventMetadata.getter(SourceEventMetadata::source)).setter(SourceEventMetadata.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Instant> EVENT_OCCURRENCE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventOccurrenceTime").getter(SourceEventMetadata.getter(SourceEventMetadata::eventOccurrenceTime)).setter(SourceEventMetadata.setter(Builder::eventOccurrenceTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventOccurrenceTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(SourceEventMetadata.getter(SourceEventMetadata::eventType)).setter(SourceEventMetadata.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<List<Resource>> RELATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedResources").getter(SourceEventMetadata.getter(SourceEventMetadata::relatedResources)).setter(SourceEventMetadata.setter(Builder::relatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_VERSION_FIELD, SOURCE_EVENT_ID_FIELD, EVENT_ORIGIN_REGION_FIELD, RELATED_ACCOUNT_FIELD, SOURCE_FIELD, EVENT_OCCURRENCE_TIME_FIELD, EVENT_TYPE_FIELD, RELATED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceEventMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventTypeVersion;
    private final String sourceEventId;
    private final String eventOriginRegion;
    private final String relatedAccount;
    private final String source;
    private final Instant eventOccurrenceTime;
    private final String eventType;
    private final List<Resource> relatedResources;

    private SourceEventMetadata(BuilderImpl builder) {
        this.eventTypeVersion = builder.eventTypeVersion;
        this.sourceEventId = builder.sourceEventId;
        this.eventOriginRegion = builder.eventOriginRegion;
        this.relatedAccount = builder.relatedAccount;
        this.source = builder.source;
        this.eventOccurrenceTime = builder.eventOccurrenceTime;
        this.eventType = builder.eventType;
        this.relatedResources = builder.relatedResources;
    }

    public final String eventTypeVersion() {
        return this.eventTypeVersion;
    }

    public final String sourceEventId() {
        return this.sourceEventId;
    }

    public final String eventOriginRegion() {
        return this.eventOriginRegion;
    }

    public final String relatedAccount() {
        return this.relatedAccount;
    }

    public final String source() {
        return this.source;
    }

    public final Instant eventOccurrenceTime() {
        return this.eventOccurrenceTime;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final boolean hasRelatedResources() {
        return this.relatedResources != null && !(this.relatedResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> relatedResources() {
        return this.relatedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventOriginRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventOccurrenceTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedResources() ? this.relatedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceEventMetadata)) {
            return false;
        }
        SourceEventMetadata other = (SourceEventMetadata)obj;
        return Objects.equals(this.eventTypeVersion(), other.eventTypeVersion()) && Objects.equals(this.sourceEventId(), other.sourceEventId()) && Objects.equals(this.eventOriginRegion(), other.eventOriginRegion()) && Objects.equals(this.relatedAccount(), other.relatedAccount()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.eventOccurrenceTime(), other.eventOccurrenceTime()) && Objects.equals(this.eventType(), other.eventType()) && this.hasRelatedResources() == other.hasRelatedResources() && Objects.equals(this.relatedResources(), other.relatedResources());
    }

    public final String toString() {
        return ToString.builder((String)"SourceEventMetadata").add("EventTypeVersion", (Object)this.eventTypeVersion()).add("SourceEventId", (Object)this.sourceEventId()).add("EventOriginRegion", (Object)this.eventOriginRegion()).add("RelatedAccount", (Object)this.relatedAccount()).add("Source", (Object)this.source()).add("EventOccurrenceTime", (Object)this.eventOccurrenceTime()).add("EventType", (Object)this.eventType()).add("RelatedResources", this.hasRelatedResources() ? this.relatedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.eventTypeVersion()));
            }
            case "sourceEventId": {
                return Optional.ofNullable(clazz.cast(this.sourceEventId()));
            }
            case "eventOriginRegion": {
                return Optional.ofNullable(clazz.cast(this.eventOriginRegion()));
            }
            case "relatedAccount": {
                return Optional.ofNullable(clazz.cast(this.relatedAccount()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "eventOccurrenceTime": {
                return Optional.ofNullable(clazz.cast(this.eventOccurrenceTime()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "relatedResources": {
                return Optional.ofNullable(clazz.cast(this.relatedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventTypeVersion", EVENT_TYPE_VERSION_FIELD);
        map.put("sourceEventId", SOURCE_EVENT_ID_FIELD);
        map.put("eventOriginRegion", EVENT_ORIGIN_REGION_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("eventOccurrenceTime", EVENT_OCCURRENCE_TIME_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("relatedResources", RELATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceEventMetadata, T> g) {
        return obj -> g.apply((SourceEventMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventTypeVersion;
        private String sourceEventId;
        private String eventOriginRegion;
        private String relatedAccount;
        private String source;
        private Instant eventOccurrenceTime;
        private String eventType;
        private List<Resource> relatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceEventMetadata model) {
            this.eventTypeVersion(model.eventTypeVersion);
            this.sourceEventId(model.sourceEventId);
            this.eventOriginRegion(model.eventOriginRegion);
            this.relatedAccount(model.relatedAccount);
            this.source(model.source);
            this.eventOccurrenceTime(model.eventOccurrenceTime);
            this.eventType(model.eventType);
            this.relatedResources(model.relatedResources);
        }

        public final String getEventTypeVersion() {
            return this.eventTypeVersion;
        }

        public final void setEventTypeVersion(String eventTypeVersion) {
            this.eventTypeVersion = eventTypeVersion;
        }

        @Override
        public final Builder eventTypeVersion(String eventTypeVersion) {
            this.eventTypeVersion = eventTypeVersion;
            return this;
        }

        public final String getSourceEventId() {
            return this.sourceEventId;
        }

        public final void setSourceEventId(String sourceEventId) {
            this.sourceEventId = sourceEventId;
        }

        @Override
        public final Builder sourceEventId(String sourceEventId) {
            this.sourceEventId = sourceEventId;
            return this;
        }

        public final String getEventOriginRegion() {
            return this.eventOriginRegion;
        }

        public final void setEventOriginRegion(String eventOriginRegion) {
            this.eventOriginRegion = eventOriginRegion;
        }

        @Override
        public final Builder eventOriginRegion(String eventOriginRegion) {
            this.eventOriginRegion = eventOriginRegion;
            return this;
        }

        public final String getRelatedAccount() {
            return this.relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Instant getEventOccurrenceTime() {
            return this.eventOccurrenceTime;
        }

        public final void setEventOccurrenceTime(Instant eventOccurrenceTime) {
            this.eventOccurrenceTime = eventOccurrenceTime;
        }

        @Override
        public final Builder eventOccurrenceTime(Instant eventOccurrenceTime) {
            this.eventOccurrenceTime = eventOccurrenceTime;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final List<Resource.Builder> getRelatedResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.relatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedResources(Collection<Resource.BuilderImpl> relatedResources) {
            this.relatedResources = ResourcesCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public final Builder relatedResources(Collection<Resource> relatedResources) {
            this.relatedResources = ResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Resource ... relatedResources) {
            this.relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<Resource.Builder> ... relatedResources) {
            this.relatedResources(Stream.of(relatedResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SourceEventMetadata build() {
            return new SourceEventMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceEventMetadata> {
        public Builder eventTypeVersion(String var1);

        public Builder sourceEventId(String var1);

        public Builder eventOriginRegion(String var1);

        public Builder relatedAccount(String var1);

        public Builder source(String var1);

        public Builder eventOccurrenceTime(Instant var1);

        public Builder eventType(String var1);

        public Builder relatedResources(Collection<Resource> var1);

        public Builder relatedResources(Resource ... var1);

        public Builder relatedResources(Consumer<Resource.Builder> ... var1);
    }
}

