/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.AggregationDetail;
import software.amazon.awssdk.services.notifications.model.EventStatus;
import software.amazon.awssdk.services.notifications.model.ManagedSourceEventMetadataSummary;
import software.amazon.awssdk.services.notifications.model.MessageComponentsSummary;
import software.amazon.awssdk.services.notifications.model.NotificationType;
import software.amazon.awssdk.services.notifications.model.SchemaVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedNotificationChildEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedNotificationChildEventSummary> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::schemaVersionAsString)).setter(ManagedNotificationChildEventSummary.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<ManagedSourceEventMetadataSummary> SOURCE_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceEventMetadata").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::sourceEventMetadata)).setter(ManagedNotificationChildEventSummary.setter(Builder::sourceEventMetadata)).constructor(ManagedSourceEventMetadataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventMetadata").build()}).build();
    private static final SdkField<MessageComponentsSummary> MESSAGE_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageComponents").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::messageComponents)).setter(ManagedNotificationChildEventSummary.setter(Builder::messageComponents)).constructor(MessageComponentsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageComponents").build()}).build();
    private static final SdkField<AggregationDetail> AGGREGATION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationDetail").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::aggregationDetail)).setter(ManagedNotificationChildEventSummary.setter(Builder::aggregationDetail)).constructor(AggregationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDetail").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventStatus").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::eventStatusAsString)).setter(ManagedNotificationChildEventSummary.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationType").getter(ManagedNotificationChildEventSummary.getter(ManagedNotificationChildEventSummary::notificationTypeAsString)).setter(ManagedNotificationChildEventSummary.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD, SOURCE_EVENT_METADATA_FIELD, MESSAGE_COMPONENTS_FIELD, AGGREGATION_DETAIL_FIELD, EVENT_STATUS_FIELD, NOTIFICATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedNotificationChildEventSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String schemaVersion;
    private final ManagedSourceEventMetadataSummary sourceEventMetadata;
    private final MessageComponentsSummary messageComponents;
    private final AggregationDetail aggregationDetail;
    private final String eventStatus;
    private final String notificationType;

    private ManagedNotificationChildEventSummary(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.sourceEventMetadata = builder.sourceEventMetadata;
        this.messageComponents = builder.messageComponents;
        this.aggregationDetail = builder.aggregationDetail;
        this.eventStatus = builder.eventStatus;
        this.notificationType = builder.notificationType;
    }

    public final SchemaVersion schemaVersion() {
        return SchemaVersion.fromValue(this.schemaVersion);
    }

    public final String schemaVersionAsString() {
        return this.schemaVersion;
    }

    public final ManagedSourceEventMetadataSummary sourceEventMetadata() {
        return this.sourceEventMetadata;
    }

    public final MessageComponentsSummary messageComponents() {
        return this.messageComponents;
    }

    public final AggregationDetail aggregationDetail() {
        return this.aggregationDetail;
    }

    public final EventStatus eventStatus() {
        return EventStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public final NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public final String notificationTypeAsString() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageComponents());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChildEventSummary)) {
            return false;
        }
        ManagedNotificationChildEventSummary other = (ManagedNotificationChildEventSummary)obj;
        return Objects.equals(this.schemaVersionAsString(), other.schemaVersionAsString()) && Objects.equals(this.sourceEventMetadata(), other.sourceEventMetadata()) && Objects.equals(this.messageComponents(), other.messageComponents()) && Objects.equals(this.aggregationDetail(), other.aggregationDetail()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedNotificationChildEventSummary").add("SchemaVersion", (Object)this.schemaVersionAsString()).add("SourceEventMetadata", (Object)this.sourceEventMetadata()).add("MessageComponents", (Object)this.messageComponents()).add("AggregationDetail", (Object)this.aggregationDetail()).add("EventStatus", (Object)this.eventStatusAsString()).add("NotificationType", (Object)this.notificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionAsString()));
            }
            case "sourceEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.sourceEventMetadata()));
            }
            case "messageComponents": {
                return Optional.ofNullable(clazz.cast(this.messageComponents()));
            }
            case "aggregationDetail": {
                return Optional.ofNullable(clazz.cast(this.aggregationDetail()));
            }
            case "eventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
            case "notificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("sourceEventMetadata", SOURCE_EVENT_METADATA_FIELD);
        map.put("messageComponents", MESSAGE_COMPONENTS_FIELD);
        map.put("aggregationDetail", AGGREGATION_DETAIL_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        map.put("notificationType", NOTIFICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChildEventSummary, T> g) {
        return obj -> g.apply((ManagedNotificationChildEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaVersion;
        private ManagedSourceEventMetadataSummary sourceEventMetadata;
        private MessageComponentsSummary messageComponents;
        private AggregationDetail aggregationDetail;
        private String eventStatus;
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChildEventSummary model) {
            this.schemaVersion(model.schemaVersion);
            this.sourceEventMetadata(model.sourceEventMetadata);
            this.messageComponents(model.messageComponents);
            this.aggregationDetail(model.aggregationDetail);
            this.eventStatus(model.eventStatus);
            this.notificationType(model.notificationType);
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public final Builder schemaVersion(SchemaVersion schemaVersion) {
            this.schemaVersion(schemaVersion == null ? null : schemaVersion.toString());
            return this;
        }

        public final ManagedSourceEventMetadataSummary.Builder getSourceEventMetadata() {
            return this.sourceEventMetadata != null ? this.sourceEventMetadata.toBuilder() : null;
        }

        public final void setSourceEventMetadata(ManagedSourceEventMetadataSummary.BuilderImpl sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata != null ? sourceEventMetadata.build() : null;
        }

        @Override
        public final Builder sourceEventMetadata(ManagedSourceEventMetadataSummary sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata;
            return this;
        }

        public final MessageComponentsSummary.Builder getMessageComponents() {
            return this.messageComponents != null ? this.messageComponents.toBuilder() : null;
        }

        public final void setMessageComponents(MessageComponentsSummary.BuilderImpl messageComponents) {
            this.messageComponents = messageComponents != null ? messageComponents.build() : null;
        }

        @Override
        public final Builder messageComponents(MessageComponentsSummary messageComponents) {
            this.messageComponents = messageComponents;
            return this;
        }

        public final AggregationDetail.Builder getAggregationDetail() {
            return this.aggregationDetail != null ? this.aggregationDetail.toBuilder() : null;
        }

        public final void setAggregationDetail(AggregationDetail.BuilderImpl aggregationDetail) {
            this.aggregationDetail = aggregationDetail != null ? aggregationDetail.build() : null;
        }

        @Override
        public final Builder aggregationDetail(AggregationDetail aggregationDetail) {
            this.aggregationDetail = aggregationDetail;
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public ManagedNotificationChildEventSummary build() {
            return new ManagedNotificationChildEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedNotificationChildEventSummary> {
        public Builder schemaVersion(String var1);

        public Builder schemaVersion(SchemaVersion var1);

        public Builder sourceEventMetadata(ManagedSourceEventMetadataSummary var1);

        default public Builder sourceEventMetadata(Consumer<ManagedSourceEventMetadataSummary.Builder> sourceEventMetadata) {
            return this.sourceEventMetadata((ManagedSourceEventMetadataSummary)((ManagedSourceEventMetadataSummary.Builder)ManagedSourceEventMetadataSummary.builder().applyMutation(sourceEventMetadata)).build());
        }

        public Builder messageComponents(MessageComponentsSummary var1);

        default public Builder messageComponents(Consumer<MessageComponentsSummary.Builder> messageComponents) {
            return this.messageComponents((MessageComponentsSummary)((MessageComponentsSummary.Builder)MessageComponentsSummary.builder().applyMutation(messageComponents)).build());
        }

        public Builder aggregationDetail(AggregationDetail var1);

        default public Builder aggregationDetail(Consumer<AggregationDetail.Builder> aggregationDetail) {
            return this.aggregationDetail((AggregationDetail)((AggregationDetail.Builder)AggregationDetail.builder().applyMutation(aggregationDetail)).build());
        }

        public Builder eventStatus(String var1);

        public Builder eventStatus(EventStatus var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);
    }
}

