/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChannelAssociationSummary;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChannelAssociationsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedNotificationChannelAssociationsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListManagedNotificationChannelAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedNotificationChannelAssociationsResponse.getter(ListManagedNotificationChannelAssociationsResponse::nextToken)).setter(ListManagedNotificationChannelAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedNotificationChannelAssociationSummary>> CHANNEL_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channelAssociations").getter(ListManagedNotificationChannelAssociationsResponse.getter(ListManagedNotificationChannelAssociationsResponse::channelAssociations)).setter(ListManagedNotificationChannelAssociationsResponse.setter(Builder::channelAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedNotificationChannelAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CHANNEL_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedNotificationChannelAssociationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ManagedNotificationChannelAssociationSummary> channelAssociations;

    private ListManagedNotificationChannelAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.channelAssociations = builder.channelAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasChannelAssociations() {
        return this.channelAssociations != null && !(this.channelAssociations instanceof SdkAutoConstructList);
    }

    public final List<ManagedNotificationChannelAssociationSummary> channelAssociations() {
        return this.channelAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelAssociations() ? this.channelAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationChannelAssociationsResponse)) {
            return false;
        }
        ListManagedNotificationChannelAssociationsResponse other = (ListManagedNotificationChannelAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasChannelAssociations() == other.hasChannelAssociations() && Objects.equals(this.channelAssociations(), other.channelAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedNotificationChannelAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("ChannelAssociations", this.hasChannelAssociations() ? this.channelAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "channelAssociations": {
                return Optional.ofNullable(clazz.cast(this.channelAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("channelAssociations", CHANNEL_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationChannelAssociationsResponse, T> g) {
        return obj -> g.apply((ListManagedNotificationChannelAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedNotificationChannelAssociationSummary> channelAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationChannelAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.channelAssociations(model.channelAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedNotificationChannelAssociationSummary.Builder> getChannelAssociations() {
            List<ManagedNotificationChannelAssociationSummary.Builder> result = ManagedNotificationChannelAssociationsCopier.copyToBuilder(this.channelAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelAssociations(Collection<ManagedNotificationChannelAssociationSummary.BuilderImpl> channelAssociations) {
            this.channelAssociations = ManagedNotificationChannelAssociationsCopier.copyFromBuilder(channelAssociations);
        }

        @Override
        public final Builder channelAssociations(Collection<ManagedNotificationChannelAssociationSummary> channelAssociations) {
            this.channelAssociations = ManagedNotificationChannelAssociationsCopier.copy(channelAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelAssociations(ManagedNotificationChannelAssociationSummary ... channelAssociations) {
            this.channelAssociations(Arrays.asList(channelAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelAssociations(Consumer<ManagedNotificationChannelAssociationSummary.Builder> ... channelAssociations) {
            this.channelAssociations(Stream.of(channelAssociations).map(c -> (ManagedNotificationChannelAssociationSummary)((ManagedNotificationChannelAssociationSummary.Builder)ManagedNotificationChannelAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedNotificationChannelAssociationsResponse build() {
            return new ListManagedNotificationChannelAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedNotificationChannelAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder channelAssociations(Collection<ManagedNotificationChannelAssociationSummary> var1);

        public Builder channelAssociations(ManagedNotificationChannelAssociationSummary ... var1);

        public Builder channelAssociations(Consumer<ManagedNotificationChannelAssociationSummary.Builder> ... var1);
    }
}

