/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LocaleCode {
    DE_DE("de_DE"),
    EN_CA("en_CA"),
    EN_US("en_US"),
    EN_UK("en_UK"),
    ES_ES("es_ES"),
    FR_CA("fr_CA"),
    FR_FR("fr_FR"),
    ID_ID("id_ID"),
    IT_IT("it_IT"),
    JA_JP("ja_JP"),
    KO_KR("ko_KR"),
    PT_BR("pt_BR"),
    TR_TR("tr_TR"),
    ZH_CN("zh_CN"),
    ZH_TW("zh_TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LocaleCode> VALUE_MAP;
    private final String value;

    private LocaleCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LocaleCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LocaleCode> knownValues() {
        EnumSet<LocaleCode> knownValues = EnumSet.allOf(LocaleCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LocaleCode.class, LocaleCode::toString);
    }
}

