/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.Dimension;
import software.amazon.awssdk.services.notifications.model.DimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageComponents
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageComponents> {
    private static final SdkField<String> HEADLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("headline").getter(MessageComponents.getter(MessageComponents::headline)).setter(MessageComponents.setter(Builder::headline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headline").build()}).build();
    private static final SdkField<String> PARAGRAPH_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("paragraphSummary").getter(MessageComponents.getter(MessageComponents::paragraphSummary)).setter(MessageComponents.setter(Builder::paragraphSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paragraphSummary").build()}).build();
    private static final SdkField<String> COMPLETE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completeDescription").getter(MessageComponents.getter(MessageComponents::completeDescription)).setter(MessageComponents.setter(Builder::completeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completeDescription").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensions").getter(MessageComponents.getter(MessageComponents::dimensions)).setter(MessageComponents.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADLINE_FIELD, PARAGRAPH_SUMMARY_FIELD, COMPLETE_DESCRIPTION_FIELD, DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageComponents.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String headline;
    private final String paragraphSummary;
    private final String completeDescription;
    private final List<Dimension> dimensions;

    private MessageComponents(BuilderImpl builder) {
        this.headline = builder.headline;
        this.paragraphSummary = builder.paragraphSummary;
        this.completeDescription = builder.completeDescription;
        this.dimensions = builder.dimensions;
    }

    public final String headline() {
        return this.headline;
    }

    public final String paragraphSummary() {
        return this.paragraphSummary;
    }

    public final String completeDescription() {
        return this.completeDescription;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.headline());
        hashCode = 31 * hashCode + Objects.hashCode(this.paragraphSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageComponents)) {
            return false;
        }
        MessageComponents other = (MessageComponents)obj;
        return Objects.equals(this.headline(), other.headline()) && Objects.equals(this.paragraphSummary(), other.paragraphSummary()) && Objects.equals(this.completeDescription(), other.completeDescription()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions());
    }

    public final String toString() {
        return ToString.builder((String)"MessageComponents").add("Headline", (Object)this.headline()).add("ParagraphSummary", (Object)this.paragraphSummary()).add("CompleteDescription", (Object)this.completeDescription()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headline": {
                return Optional.ofNullable(clazz.cast(this.headline()));
            }
            case "paragraphSummary": {
                return Optional.ofNullable(clazz.cast(this.paragraphSummary()));
            }
            case "completeDescription": {
                return Optional.ofNullable(clazz.cast(this.completeDescription()));
            }
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("headline", HEADLINE_FIELD);
        map.put("paragraphSummary", PARAGRAPH_SUMMARY_FIELD);
        map.put("completeDescription", COMPLETE_DESCRIPTION_FIELD);
        map.put("dimensions", DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageComponents, T> g) {
        return obj -> g.apply((MessageComponents)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String headline;
        private String paragraphSummary;
        private String completeDescription;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageComponents model) {
            this.headline(model.headline);
            this.paragraphSummary(model.paragraphSummary);
            this.completeDescription(model.completeDescription);
            this.dimensions(model.dimensions);
        }

        public final String getHeadline() {
            return this.headline;
        }

        public final void setHeadline(String headline) {
            this.headline = headline;
        }

        @Override
        public final Builder headline(String headline) {
            this.headline = headline;
            return this;
        }

        public final String getParagraphSummary() {
            return this.paragraphSummary;
        }

        public final void setParagraphSummary(String paragraphSummary) {
            this.paragraphSummary = paragraphSummary;
        }

        @Override
        public final Builder paragraphSummary(String paragraphSummary) {
            this.paragraphSummary = paragraphSummary;
            return this;
        }

        public final String getCompleteDescription() {
            return this.completeDescription;
        }

        public final void setCompleteDescription(String completeDescription) {
            this.completeDescription = completeDescription;
        }

        @Override
        public final Builder completeDescription(String completeDescription) {
            this.completeDescription = completeDescription;
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MessageComponents build() {
            return new MessageComponents(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageComponents> {
        public Builder headline(String var1);

        public Builder paragraphSummary(String var1);

        public Builder completeDescription(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);
    }
}

