/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.AggregationEventType;
import software.amazon.awssdk.services.notifications.model.NotificationEventSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationEventOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(NotificationEventOverview.getter(NotificationEventOverview::arn)).setter(NotificationEventOverview.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationConfigurationArn").getter(NotificationEventOverview.getter(NotificationEventOverview::notificationConfigurationArn)).setter(NotificationEventOverview.setter(Builder::notificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn").build()}).build();
    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedAccount").getter(NotificationEventOverview.getter(NotificationEventOverview::relatedAccount)).setter(NotificationEventOverview.setter(Builder::relatedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(NotificationEventOverview.getter(NotificationEventOverview::creationTime)).setter(NotificationEventOverview.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<NotificationEventSummary> NOTIFICATION_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notificationEvent").getter(NotificationEventOverview.getter(NotificationEventOverview::notificationEvent)).setter(NotificationEventOverview.setter(Builder::notificationEvent)).constructor(NotificationEventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEvent").build()}).build();
    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationEventType").getter(NotificationEventOverview.getter(NotificationEventOverview::aggregationEventTypeAsString)).setter(NotificationEventOverview.setter(Builder::aggregationEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build()}).build();
    private static final SdkField<String> AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregateNotificationEventArn").getter(NotificationEventOverview.getter(NotificationEventOverview::aggregateNotificationEventArn)).setter(NotificationEventOverview.setter(Builder::aggregateNotificationEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateNotificationEventArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, NOTIFICATION_EVENT_FIELD, AGGREGATION_EVENT_TYPE_FIELD, AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationEventOverview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String notificationConfigurationArn;
    private final String relatedAccount;
    private final Instant creationTime;
    private final NotificationEventSummary notificationEvent;
    private final String aggregationEventType;
    private final String aggregateNotificationEventArn;

    private NotificationEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.notificationEvent = builder.notificationEvent;
        this.aggregationEventType = builder.aggregationEventType;
        this.aggregateNotificationEventArn = builder.aggregateNotificationEventArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final String notificationConfigurationArn() {
        return this.notificationConfigurationArn;
    }

    public final String relatedAccount() {
        return this.relatedAccount;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final NotificationEventSummary notificationEvent() {
        return this.notificationEvent;
    }

    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(this.aggregationEventType);
    }

    public final String aggregationEventTypeAsString() {
        return this.aggregationEventType;
    }

    public final String aggregateNotificationEventArn() {
        return this.aggregateNotificationEventArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateNotificationEventArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationEventOverview)) {
            return false;
        }
        NotificationEventOverview other = (NotificationEventOverview)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.notificationConfigurationArn(), other.notificationConfigurationArn()) && Objects.equals(this.relatedAccount(), other.relatedAccount()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.notificationEvent(), other.notificationEvent()) && Objects.equals(this.aggregationEventTypeAsString(), other.aggregationEventTypeAsString()) && Objects.equals(this.aggregateNotificationEventArn(), other.aggregateNotificationEventArn());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationEventOverview").add("Arn", (Object)this.arn()).add("NotificationConfigurationArn", (Object)this.notificationConfigurationArn()).add("RelatedAccount", (Object)this.relatedAccount()).add("CreationTime", (Object)this.creationTime()).add("NotificationEvent", (Object)this.notificationEvent()).add("AggregationEventType", (Object)this.aggregationEventTypeAsString()).add("AggregateNotificationEventArn", (Object)this.aggregateNotificationEventArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "notificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationArn()));
            }
            case "relatedAccount": {
                return Optional.ofNullable(clazz.cast(this.relatedAccount()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "notificationEvent": {
                return Optional.ofNullable(clazz.cast(this.notificationEvent()));
            }
            case "aggregationEventType": {
                return Optional.ofNullable(clazz.cast(this.aggregationEventTypeAsString()));
            }
            case "aggregateNotificationEventArn": {
                return Optional.ofNullable(clazz.cast(this.aggregateNotificationEventArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("notificationEvent", NOTIFICATION_EVENT_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("aggregateNotificationEventArn", AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationEventOverview, T> g) {
        return obj -> g.apply((NotificationEventOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String notificationConfigurationArn;
        private String relatedAccount;
        private Instant creationTime;
        private NotificationEventSummary notificationEvent;
        private String aggregationEventType;
        private String aggregateNotificationEventArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationEventOverview model) {
            this.arn(model.arn);
            this.notificationConfigurationArn(model.notificationConfigurationArn);
            this.relatedAccount(model.relatedAccount);
            this.creationTime(model.creationTime);
            this.notificationEvent(model.notificationEvent);
            this.aggregationEventType(model.aggregationEventType);
            this.aggregateNotificationEventArn(model.aggregateNotificationEventArn);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return this.relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final NotificationEventSummary.Builder getNotificationEvent() {
            return this.notificationEvent != null ? this.notificationEvent.toBuilder() : null;
        }

        public final void setNotificationEvent(NotificationEventSummary.BuilderImpl notificationEvent) {
            this.notificationEvent = notificationEvent != null ? notificationEvent.build() : null;
        }

        @Override
        public final Builder notificationEvent(NotificationEventSummary notificationEvent) {
            this.notificationEvent = notificationEvent;
            return this;
        }

        public final String getAggregationEventType() {
            return this.aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final String getAggregateNotificationEventArn() {
            return this.aggregateNotificationEventArn;
        }

        public final void setAggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
        }

        @Override
        public final Builder aggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
            return this;
        }

        public NotificationEventOverview build() {
            return new NotificationEventOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationEventOverview> {
        public Builder arn(String var1);

        public Builder notificationConfigurationArn(String var1);

        public Builder relatedAccount(String var1);

        public Builder creationTime(Instant var1);

        public Builder notificationEvent(NotificationEventSummary var1);

        default public Builder notificationEvent(Consumer<NotificationEventSummary.Builder> notificationEvent) {
            return this.notificationEvent((NotificationEventSummary)((NotificationEventSummary.Builder)NotificationEventSummary.builder().applyMutation(notificationEvent)).build());
        }

        public Builder aggregationEventType(String var1);

        public Builder aggregationEventType(AggregationEventType var1);

        public Builder aggregateNotificationEventArn(String var1);
    }
}

