/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationConfigurationStatus {
    ACTIVE("ACTIVE"),
    PARTIALLY_ACTIVE("PARTIALLY_ACTIVE"),
    INACTIVE("INACTIVE"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationConfigurationStatus> VALUE_MAP;
    private final String value;

    private NotificationConfigurationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationConfigurationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationConfigurationStatus> knownValues() {
        EnumSet<NotificationConfigurationStatus> knownValues = EnumSet.allOf(NotificationConfigurationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationConfigurationStatus.class, NotificationConfigurationStatus::toString);
    }
}

