/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.EventRuleStructure;
import software.amazon.awssdk.services.notifications.model.ListEventRulesRequest;
import software.amazon.awssdk.services.notifications.model.ListEventRulesResponse;

public class ListEventRulesPublisher
implements SdkPublisher<ListEventRulesResponse> {
    private final NotificationsAsyncClient client;
    private final ListEventRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventRulesPublisher(NotificationsAsyncClient client, ListEventRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventRulesPublisher(NotificationsAsyncClient client, ListEventRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventRuleStructure> eventRules() {
        Function<ListEventRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventRules() != null) {
                return response.eventRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventRulesResponseFetcher
    implements AsyncPageFetcher<ListEventRulesResponse> {
        private ListEventRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventRulesResponse> nextPage(ListEventRulesResponse previousPage) {
            if (previousPage == null) {
                return ListEventRulesPublisher.this.client.listEventRules(ListEventRulesPublisher.this.firstRequest);
            }
            return ListEventRulesPublisher.this.client.listEventRules((ListEventRulesRequest)((Object)ListEventRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

