/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.NotificationEventOverview;
import software.amazon.awssdk.services.notifications.model.NotificationEventsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationEventsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListNotificationEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationEventsResponse.getter(ListNotificationEventsResponse::nextToken)).setter(ListNotificationEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<NotificationEventOverview>> NOTIFICATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationEvents").getter(ListNotificationEventsResponse.getter(ListNotificationEventsResponse::notificationEvents)).setter(ListNotificationEventsResponse.setter(Builder::notificationEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationEventOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NOTIFICATION_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("notificationEvents", NOTIFICATION_EVENTS_FIELD);
        }
    });
    private final String nextToken;
    private final List<NotificationEventOverview> notificationEvents;

    private ListNotificationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationEvents = builder.notificationEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNotificationEvents() {
        return this.notificationEvents != null && !(this.notificationEvents instanceof SdkAutoConstructList);
    }

    public final List<NotificationEventOverview> notificationEvents() {
        return this.notificationEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationEvents() ? this.notificationEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationEventsResponse)) {
            return false;
        }
        ListNotificationEventsResponse other = (ListNotificationEventsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNotificationEvents() == other.hasNotificationEvents() && Objects.equals(this.notificationEvents(), other.notificationEvents());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationEventsResponse").add("NextToken", (Object)this.nextToken()).add("NotificationEvents", this.hasNotificationEvents() ? this.notificationEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "notificationEvents": {
                return Optional.ofNullable(clazz.cast(this.notificationEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationEventsResponse, T> g) {
        return obj -> g.apply((ListNotificationEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotificationEventOverview> notificationEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationEventsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notificationEvents(model.notificationEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotificationEventOverview.Builder> getNotificationEvents() {
            List<NotificationEventOverview.Builder> result = NotificationEventsCopier.copyToBuilder(this.notificationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationEvents(Collection<NotificationEventOverview.BuilderImpl> notificationEvents) {
            this.notificationEvents = NotificationEventsCopier.copyFromBuilder(notificationEvents);
        }

        @Override
        public final Builder notificationEvents(Collection<NotificationEventOverview> notificationEvents) {
            this.notificationEvents = NotificationEventsCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(NotificationEventOverview ... notificationEvents) {
            this.notificationEvents(Arrays.asList(notificationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(Consumer<NotificationEventOverview.Builder> ... notificationEvents) {
            this.notificationEvents(Stream.of(notificationEvents).map(c -> (NotificationEventOverview)((NotificationEventOverview.Builder)NotificationEventOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotificationEventsResponse build() {
            return new ListNotificationEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationEventsResponse> {
        public Builder nextToken(String var1);

        public Builder notificationEvents(Collection<NotificationEventOverview> var1);

        public Builder notificationEvents(NotificationEventOverview ... var1);

        public Builder notificationEvents(Consumer<NotificationEventOverview.Builder> ... var1);
    }
}

