/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.LocaleCode;
import software.amazon.awssdk.services.notifications.model.NotificationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationEventsRequest
extends NotificationsRequest
implements ToCopyableBuilder<Builder, ListNotificationEventsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::startTime)).setter(ListNotificationEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::endTime)).setter(ListNotificationEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::localeAsString)).setter(ListNotificationEventsRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::source)).setter(ListNotificationEventsRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CHILD_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeChildEvents").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::includeChildEvents)).setter(ListNotificationEventsRequest.setter(Builder::includeChildEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeChildEvents").build()}).build();
    private static final SdkField<String> AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregateNotificationEventArn").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::aggregateNotificationEventArn)).setter(ListNotificationEventsRequest.setter(Builder::aggregateNotificationEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aggregateNotificationEventArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::maxResults)).setter(ListNotificationEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationEventsRequest.getter(ListNotificationEventsRequest::nextToken)).setter(ListNotificationEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, LOCALE_FIELD, SOURCE_FIELD, INCLUDE_CHILD_EVENTS_FIELD, AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("locale", LOCALE_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("includeChildEvents", INCLUDE_CHILD_EVENTS_FIELD);
            this.put("aggregateNotificationEventArn", AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final Instant startTime;
    private final Instant endTime;
    private final String locale;
    private final String source;
    private final Boolean includeChildEvents;
    private final String aggregateNotificationEventArn;
    private final Integer maxResults;
    private final String nextToken;

    private ListNotificationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.locale = builder.locale;
        this.source = builder.source;
        this.includeChildEvents = builder.includeChildEvents;
        this.aggregateNotificationEventArn = builder.aggregateNotificationEventArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final LocaleCode locale() {
        return LocaleCode.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final String source() {
        return this.source;
    }

    public final Boolean includeChildEvents() {
        return this.includeChildEvents;
    }

    public final String aggregateNotificationEventArn() {
        return this.aggregateNotificationEventArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationEventsRequest)) {
            return false;
        }
        ListNotificationEventsRequest other = (ListNotificationEventsRequest)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.includeChildEvents(), other.includeChildEvents()) && Objects.equals(this.aggregateNotificationEventArn(), other.aggregateNotificationEventArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationEventsRequest").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Locale", (Object)this.localeAsString()).add("Source", (Object)this.source()).add("IncludeChildEvents", (Object)this.includeChildEvents()).add("AggregateNotificationEventArn", (Object)this.aggregateNotificationEventArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "includeChildEvents": {
                return Optional.ofNullable(clazz.cast(this.includeChildEvents()));
            }
            case "aggregateNotificationEventArn": {
                return Optional.ofNullable(clazz.cast(this.aggregateNotificationEventArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationEventsRequest, T> g) {
        return obj -> g.apply((ListNotificationEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsRequest.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private String locale;
        private String source;
        private Boolean includeChildEvents;
        private String aggregateNotificationEventArn;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationEventsRequest model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.locale(model.locale);
            this.source(model.source);
            this.includeChildEvents(model.includeChildEvents);
            this.aggregateNotificationEventArn(model.aggregateNotificationEventArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleCode locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Boolean getIncludeChildEvents() {
            return this.includeChildEvents;
        }

        public final void setIncludeChildEvents(Boolean includeChildEvents) {
            this.includeChildEvents = includeChildEvents;
        }

        @Override
        public final Builder includeChildEvents(Boolean includeChildEvents) {
            this.includeChildEvents = includeChildEvents;
            return this;
        }

        public final String getAggregateNotificationEventArn() {
            return this.aggregateNotificationEventArn;
        }

        public final void setAggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
        }

        @Override
        public final Builder aggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationEventsRequest build() {
            return new ListNotificationEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationEventsRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder locale(String var1);

        public Builder locale(LocaleCode var1);

        public Builder source(String var1);

        public Builder includeChildEvents(Boolean var1);

        public Builder aggregateNotificationEventArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

