/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.LaunchProfile;

final class LaunchProfileListCopier {
    LaunchProfileListCopier() {
    }

    static List<LaunchProfile> copy(Collection<? extends LaunchProfile> launchProfileListParam) {
        Object list;
        if (launchProfileListParam == null || launchProfileListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(launchProfileListParam.size());
            launchProfileListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LaunchProfile> copyFromBuilder(Collection<? extends LaunchProfile.Builder> launchProfileListParam) {
        Object list;
        if (launchProfileListParam == null || launchProfileListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(launchProfileListParam.size());
            launchProfileListParam.forEach(entry -> {
                LaunchProfile member = entry == null ? null : (LaunchProfile)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LaunchProfile.Builder> copyToBuilder(Collection<? extends LaunchProfile> launchProfileListParam) {
        Object list;
        if (launchProfileListParam == null || launchProfileListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(launchProfileListParam.size());
            launchProfileListParam.forEach(entry -> {
                LaunchProfile.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

