/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.LaunchProfileMembership;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse;

public class ListLaunchProfileMembersPublisher
implements SdkPublisher<ListLaunchProfileMembersResponse> {
    private final NimbleAsyncClient client;
    private final ListLaunchProfileMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLaunchProfileMembersPublisher(NimbleAsyncClient client, ListLaunchProfileMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLaunchProfileMembersPublisher(NimbleAsyncClient client, ListLaunchProfileMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLaunchProfileMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLaunchProfileMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchProfileMembership> members() {
        Function<ListLaunchProfileMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLaunchProfileMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLaunchProfileMembersResponseFetcher
    implements AsyncPageFetcher<ListLaunchProfileMembersResponse> {
        private ListLaunchProfileMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchProfileMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLaunchProfileMembersResponse> nextPage(ListLaunchProfileMembersResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchProfileMembersPublisher.this.client.listLaunchProfileMembers(ListLaunchProfileMembersPublisher.this.firstRequest);
            }
            return ListLaunchProfileMembersPublisher.this.client.listLaunchProfileMembers((ListLaunchProfileMembersRequest)((Object)ListLaunchProfileMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

