/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("iops").getter(VolumeConfiguration.getter(VolumeConfiguration::iops)).setter(VolumeConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("size").getter(VolumeConfiguration.getter(VolumeConfiguration::size)).setter(VolumeConfiguration.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("throughput").getter(VolumeConfiguration.getter(VolumeConfiguration::throughput)).setter(VolumeConfiguration.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, SIZE_FIELD, THROUGHPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer iops;
    private final Integer size;
    private final Integer throughput;

    private VolumeConfiguration(BuilderImpl builder) {
        this.iops = builder.iops;
        this.size = builder.size;
        this.throughput = builder.throughput;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer size() {
        return this.size;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        return Objects.equals(this.iops(), other.iops()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.throughput(), other.throughput());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeConfiguration").add("Iops", (Object)this.iops()).add("Size", (Object)this.size()).add("Throughput", (Object)this.throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer iops;
        private Integer size;
        private Integer throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.iops(model.iops);
            this.size(model.size);
            this.throughput(model.throughput);
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder iops(Integer var1);

        public Builder size(Integer var1);

        public Builder throughput(Integer var1);
    }
}

