/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.StudioMembership;

public class ListStudioMembersPublisher
implements SdkPublisher<ListStudioMembersResponse> {
    private final NimbleAsyncClient client;
    private final ListStudioMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStudioMembersPublisher(NimbleAsyncClient client, ListStudioMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStudioMembersPublisher(NimbleAsyncClient client, ListStudioMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStudioMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStudioMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StudioMembership> members() {
        Function<ListStudioMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStudioMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStudioMembersResponseFetcher
    implements AsyncPageFetcher<ListStudioMembersResponse> {
        private ListStudioMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStudioMembersResponse> nextPage(ListStudioMembersResponse previousPage) {
            if (previousPage == null) {
                return ListStudioMembersPublisher.this.client.listStudioMembers(ListStudioMembersPublisher.this.firstRequest);
            }
            return ListStudioMembersPublisher.this.client.listStudioMembers((ListStudioMembersRequest)((Object)ListStudioMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

