/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSessionBackup;

public class ListStreamingSessionBackupsIterable
implements SdkIterable<ListStreamingSessionBackupsResponse> {
    private final NimbleClient client;
    private final ListStreamingSessionBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingSessionBackupsIterable(NimbleClient client, ListStreamingSessionBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamingSessionBackupsResponseFetcher();
    }

    public Iterator<ListStreamingSessionBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamingSessionBackup> streamingSessionBackups() {
        Function<ListStreamingSessionBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingSessionBackups() != null) {
                return response.streamingSessionBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamingSessionBackupsResponseFetcher
    implements SyncPageFetcher<ListStreamingSessionBackupsResponse> {
        private ListStreamingSessionBackupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingSessionBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamingSessionBackupsResponse nextPage(ListStreamingSessionBackupsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingSessionBackupsIterable.this.client.listStreamingSessionBackups(ListStreamingSessionBackupsIterable.this.firstRequest);
            }
            return ListStreamingSessionBackupsIterable.this.client.listStreamingSessionBackups((ListStreamingSessionBackupsRequest)((Object)ListStreamingSessionBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

