/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPrefixListAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPrefixListAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.PrefixListAssociation;

public class ListCoreNetworkPrefixListAssociationsIterable
implements SdkIterable<ListCoreNetworkPrefixListAssociationsResponse> {
    private final NetworkManagerClient client;
    private final ListCoreNetworkPrefixListAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoreNetworkPrefixListAssociationsIterable(NetworkManagerClient client, ListCoreNetworkPrefixListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoreNetworkPrefixListAssociationsResponseFetcher();
    }

    public Iterator<ListCoreNetworkPrefixListAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrefixListAssociation> prefixListAssociations() {
        Function<ListCoreNetworkPrefixListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixListAssociations() != null) {
                return response.prefixListAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoreNetworkPrefixListAssociationsResponseFetcher
    implements SyncPageFetcher<ListCoreNetworkPrefixListAssociationsResponse> {
        private ListCoreNetworkPrefixListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkPrefixListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoreNetworkPrefixListAssociationsResponse nextPage(ListCoreNetworkPrefixListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkPrefixListAssociationsIterable.this.client.listCoreNetworkPrefixListAssociations(ListCoreNetworkPrefixListAssociationsIterable.this.firstRequest);
            }
            return ListCoreNetworkPrefixListAssociationsIterable.this.client.listCoreNetworkPrefixListAssociations((ListCoreNetworkPrefixListAssociationsRequest)((Object)ListCoreNetworkPrefixListAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

