/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAttachmentRoutingPolicyLabelRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, PutAttachmentRoutingPolicyLabelRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(PutAttachmentRoutingPolicyLabelRequest.getter(PutAttachmentRoutingPolicyLabelRequest::coreNetworkId)).setter(PutAttachmentRoutingPolicyLabelRequest.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(PutAttachmentRoutingPolicyLabelRequest.getter(PutAttachmentRoutingPolicyLabelRequest::attachmentId)).setter(PutAttachmentRoutingPolicyLabelRequest.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<String> ROUTING_POLICY_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingPolicyLabel").getter(PutAttachmentRoutingPolicyLabelRequest.getter(PutAttachmentRoutingPolicyLabelRequest::routingPolicyLabel)).setter(PutAttachmentRoutingPolicyLabelRequest.setter(Builder::routingPolicyLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicyLabel").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(PutAttachmentRoutingPolicyLabelRequest.getter(PutAttachmentRoutingPolicyLabelRequest::clientToken)).setter(PutAttachmentRoutingPolicyLabelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, ATTACHMENT_ID_FIELD, ROUTING_POLICY_LABEL_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAttachmentRoutingPolicyLabelRequest.memberNameToFieldInitializer();
    private final String coreNetworkId;
    private final String attachmentId;
    private final String routingPolicyLabel;
    private final String clientToken;

    private PutAttachmentRoutingPolicyLabelRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.attachmentId = builder.attachmentId;
        this.routingPolicyLabel = builder.routingPolicyLabel;
        this.clientToken = builder.clientToken;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String routingPolicyLabel() {
        return this.routingPolicyLabel;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingPolicyLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttachmentRoutingPolicyLabelRequest)) {
            return false;
        }
        PutAttachmentRoutingPolicyLabelRequest other = (PutAttachmentRoutingPolicyLabelRequest)((Object)obj);
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.routingPolicyLabel(), other.routingPolicyLabel()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutAttachmentRoutingPolicyLabelRequest").add("CoreNetworkId", (Object)this.coreNetworkId()).add("AttachmentId", (Object)this.attachmentId()).add("RoutingPolicyLabel", (Object)this.routingPolicyLabel()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "RoutingPolicyLabel": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyLabel()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("RoutingPolicyLabel", ROUTING_POLICY_LABEL_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAttachmentRoutingPolicyLabelRequest, T> g) {
        return obj -> g.apply((PutAttachmentRoutingPolicyLabelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String attachmentId;
        private String routingPolicyLabel;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAttachmentRoutingPolicyLabelRequest model) {
            super(model);
            this.coreNetworkId(model.coreNetworkId);
            this.attachmentId(model.attachmentId);
            this.routingPolicyLabel(model.routingPolicyLabel);
            this.clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getRoutingPolicyLabel() {
            return this.routingPolicyLabel;
        }

        public final void setRoutingPolicyLabel(String routingPolicyLabel) {
            this.routingPolicyLabel = routingPolicyLabel;
        }

        @Override
        public final Builder routingPolicyLabel(String routingPolicyLabel) {
            this.routingPolicyLabel = routingPolicyLabel;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAttachmentRoutingPolicyLabelRequest build() {
            return new PutAttachmentRoutingPolicyLabelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAttachmentRoutingPolicyLabelRequest> {
        public Builder coreNetworkId(String var1);

        public Builder attachmentId(String var1);

        public Builder routingPolicyLabel(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

