/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrefixListAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrefixListAssociation> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(PrefixListAssociation.getter(PrefixListAssociation::coreNetworkId)).setter(PrefixListAssociation.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListArn").getter(PrefixListAssociation.getter(PrefixListAssociation::prefixListArn)).setter(PrefixListAssociation.setter(Builder::prefixListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListArn").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListAlias").getter(PrefixListAssociation.getter(PrefixListAssociation::prefixListAlias)).setter(PrefixListAssociation.setter(Builder::prefixListAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, PREFIX_LIST_ARN_FIELD, PREFIX_LIST_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrefixListAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final String prefixListArn;
    private final String prefixListAlias;

    private PrefixListAssociation(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.prefixListArn = builder.prefixListArn;
        this.prefixListAlias = builder.prefixListAlias;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String prefixListArn() {
        return this.prefixListArn;
    }

    public final String prefixListAlias() {
        return this.prefixListAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixListAssociation)) {
            return false;
        }
        PrefixListAssociation other = (PrefixListAssociation)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.prefixListArn(), other.prefixListArn()) && Objects.equals(this.prefixListAlias(), other.prefixListAlias());
    }

    public final String toString() {
        return ToString.builder((String)"PrefixListAssociation").add("CoreNetworkId", (Object)this.coreNetworkId()).add("PrefixListArn", (Object)this.prefixListArn()).add("PrefixListAlias", (Object)this.prefixListAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "PrefixListArn": {
                return Optional.ofNullable(clazz.cast(this.prefixListArn()));
            }
            case "PrefixListAlias": {
                return Optional.ofNullable(clazz.cast(this.prefixListAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("PrefixListArn", PREFIX_LIST_ARN_FIELD);
        map.put("PrefixListAlias", PREFIX_LIST_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefixListAssociation, T> g) {
        return obj -> g.apply((PrefixListAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String prefixListArn;
        private String prefixListAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixListAssociation model) {
            this.coreNetworkId(model.coreNetworkId);
            this.prefixListArn(model.prefixListArn);
            this.prefixListAlias(model.prefixListAlias);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getPrefixListArn() {
            return this.prefixListArn;
        }

        public final void setPrefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
        }

        @Override
        public final Builder prefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
            return this;
        }

        public final String getPrefixListAlias() {
            return this.prefixListAlias;
        }

        public final void setPrefixListAlias(String prefixListAlias) {
            this.prefixListAlias = prefixListAlias;
        }

        @Override
        public final Builder prefixListAlias(String prefixListAlias) {
            this.prefixListAlias = prefixListAlias;
            return this;
        }

        public PrefixListAssociation build() {
            return new PrefixListAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrefixListAssociation> {
        public Builder coreNetworkId(String var1);

        public Builder prefixListArn(String var1);

        public Builder prefixListAlias(String var1);
    }
}

