/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.FilterMapCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoreNetworkRoutingInformationRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, ListCoreNetworkRoutingInformationRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::coreNetworkId)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreNetworkId").build()}).build();
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::segmentName)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::edgeLocation)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<Map<String, List<String>>> NEXT_HOP_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("NextHopFilters").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::nextHopFilters)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::nextHopFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextHopFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOCAL_PREFERENCE_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalPreferenceMatches").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::localPreferenceMatches)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::localPreferenceMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPreferenceMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXACT_AS_PATH_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExactAsPathMatches").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::exactAsPathMatches)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::exactAsPathMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExactAsPathMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MED_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MedMatches").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::medMatches)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::medMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMUNITY_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommunityMatches").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::communityMatches)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::communityMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommunityMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::maxResults)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCoreNetworkRoutingInformationRequest.getter(ListCoreNetworkRoutingInformationRequest::nextToken)).setter(ListCoreNetworkRoutingInformationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, SEGMENT_NAME_FIELD, EDGE_LOCATION_FIELD, NEXT_HOP_FILTERS_FIELD, LOCAL_PREFERENCE_MATCHES_FIELD, EXACT_AS_PATH_MATCHES_FIELD, MED_MATCHES_FIELD, COMMUNITY_MATCHES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCoreNetworkRoutingInformationRequest.memberNameToFieldInitializer();
    private final String coreNetworkId;
    private final String segmentName;
    private final String edgeLocation;
    private final Map<String, List<String>> nextHopFilters;
    private final List<String> localPreferenceMatches;
    private final List<String> exactAsPathMatches;
    private final List<String> medMatches;
    private final List<String> communityMatches;
    private final Integer maxResults;
    private final String nextToken;

    private ListCoreNetworkRoutingInformationRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.segmentName = builder.segmentName;
        this.edgeLocation = builder.edgeLocation;
        this.nextHopFilters = builder.nextHopFilters;
        this.localPreferenceMatches = builder.localPreferenceMatches;
        this.exactAsPathMatches = builder.exactAsPathMatches;
        this.medMatches = builder.medMatches;
        this.communityMatches = builder.communityMatches;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final boolean hasNextHopFilters() {
        return this.nextHopFilters != null && !(this.nextHopFilters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> nextHopFilters() {
        return this.nextHopFilters;
    }

    public final boolean hasLocalPreferenceMatches() {
        return this.localPreferenceMatches != null && !(this.localPreferenceMatches instanceof SdkAutoConstructList);
    }

    public final List<String> localPreferenceMatches() {
        return this.localPreferenceMatches;
    }

    public final boolean hasExactAsPathMatches() {
        return this.exactAsPathMatches != null && !(this.exactAsPathMatches instanceof SdkAutoConstructList);
    }

    public final List<String> exactAsPathMatches() {
        return this.exactAsPathMatches;
    }

    public final boolean hasMedMatches() {
        return this.medMatches != null && !(this.medMatches instanceof SdkAutoConstructList);
    }

    public final List<String> medMatches() {
        return this.medMatches;
    }

    public final boolean hasCommunityMatches() {
        return this.communityMatches != null && !(this.communityMatches instanceof SdkAutoConstructList);
    }

    public final List<String> communityMatches() {
        return this.communityMatches;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextHopFilters() ? this.nextHopFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalPreferenceMatches() ? this.localPreferenceMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExactAsPathMatches() ? this.exactAsPathMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedMatches() ? this.medMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommunityMatches() ? this.communityMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreNetworkRoutingInformationRequest)) {
            return false;
        }
        ListCoreNetworkRoutingInformationRequest other = (ListCoreNetworkRoutingInformationRequest)((Object)obj);
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.segmentName(), other.segmentName()) && Objects.equals(this.edgeLocation(), other.edgeLocation()) && this.hasNextHopFilters() == other.hasNextHopFilters() && Objects.equals(this.nextHopFilters(), other.nextHopFilters()) && this.hasLocalPreferenceMatches() == other.hasLocalPreferenceMatches() && Objects.equals(this.localPreferenceMatches(), other.localPreferenceMatches()) && this.hasExactAsPathMatches() == other.hasExactAsPathMatches() && Objects.equals(this.exactAsPathMatches(), other.exactAsPathMatches()) && this.hasMedMatches() == other.hasMedMatches() && Objects.equals(this.medMatches(), other.medMatches()) && this.hasCommunityMatches() == other.hasCommunityMatches() && Objects.equals(this.communityMatches(), other.communityMatches()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoreNetworkRoutingInformationRequest").add("CoreNetworkId", (Object)this.coreNetworkId()).add("SegmentName", (Object)this.segmentName()).add("EdgeLocation", (Object)this.edgeLocation()).add("NextHopFilters", this.hasNextHopFilters() ? this.nextHopFilters() : null).add("LocalPreferenceMatches", this.hasLocalPreferenceMatches() ? this.localPreferenceMatches() : null).add("ExactAsPathMatches", this.hasExactAsPathMatches() ? this.exactAsPathMatches() : null).add("MedMatches", this.hasMedMatches() ? this.medMatches() : null).add("CommunityMatches", this.hasCommunityMatches() ? this.communityMatches() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "NextHopFilters": {
                return Optional.ofNullable(clazz.cast(this.nextHopFilters()));
            }
            case "LocalPreferenceMatches": {
                return Optional.ofNullable(clazz.cast(this.localPreferenceMatches()));
            }
            case "ExactAsPathMatches": {
                return Optional.ofNullable(clazz.cast(this.exactAsPathMatches()));
            }
            case "MedMatches": {
                return Optional.ofNullable(clazz.cast(this.medMatches()));
            }
            case "CommunityMatches": {
                return Optional.ofNullable(clazz.cast(this.communityMatches()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("SegmentName", SEGMENT_NAME_FIELD);
        map.put("EdgeLocation", EDGE_LOCATION_FIELD);
        map.put("NextHopFilters", NEXT_HOP_FILTERS_FIELD);
        map.put("LocalPreferenceMatches", LOCAL_PREFERENCE_MATCHES_FIELD);
        map.put("ExactAsPathMatches", EXACT_AS_PATH_MATCHES_FIELD);
        map.put("MedMatches", MED_MATCHES_FIELD);
        map.put("CommunityMatches", COMMUNITY_MATCHES_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoreNetworkRoutingInformationRequest, T> g) {
        return obj -> g.apply((ListCoreNetworkRoutingInformationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String segmentName;
        private String edgeLocation;
        private Map<String, List<String>> nextHopFilters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> localPreferenceMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> exactAsPathMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> medMatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> communityMatches = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreNetworkRoutingInformationRequest model) {
            super(model);
            this.coreNetworkId(model.coreNetworkId);
            this.segmentName(model.segmentName);
            this.edgeLocation(model.edgeLocation);
            this.nextHopFilters(model.nextHopFilters);
            this.localPreferenceMatches(model.localPreferenceMatches);
            this.exactAsPathMatches(model.exactAsPathMatches);
            this.medMatches(model.medMatches);
            this.communityMatches(model.communityMatches);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getNextHopFilters() {
            if (this.nextHopFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.nextHopFilters;
        }

        public final void setNextHopFilters(Map<String, ? extends Collection<String>> nextHopFilters) {
            this.nextHopFilters = FilterMapCopier.copy(nextHopFilters);
        }

        @Override
        public final Builder nextHopFilters(Map<String, ? extends Collection<String>> nextHopFilters) {
            this.nextHopFilters = FilterMapCopier.copy(nextHopFilters);
            return this;
        }

        public final Collection<String> getLocalPreferenceMatches() {
            if (this.localPreferenceMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localPreferenceMatches;
        }

        public final void setLocalPreferenceMatches(Collection<String> localPreferenceMatches) {
            this.localPreferenceMatches = ConstrainedStringListCopier.copy(localPreferenceMatches);
        }

        @Override
        public final Builder localPreferenceMatches(Collection<String> localPreferenceMatches) {
            this.localPreferenceMatches = ConstrainedStringListCopier.copy(localPreferenceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localPreferenceMatches(String ... localPreferenceMatches) {
            this.localPreferenceMatches(Arrays.asList(localPreferenceMatches));
            return this;
        }

        public final Collection<String> getExactAsPathMatches() {
            if (this.exactAsPathMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exactAsPathMatches;
        }

        public final void setExactAsPathMatches(Collection<String> exactAsPathMatches) {
            this.exactAsPathMatches = ConstrainedStringListCopier.copy(exactAsPathMatches);
        }

        @Override
        public final Builder exactAsPathMatches(Collection<String> exactAsPathMatches) {
            this.exactAsPathMatches = ConstrainedStringListCopier.copy(exactAsPathMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exactAsPathMatches(String ... exactAsPathMatches) {
            this.exactAsPathMatches(Arrays.asList(exactAsPathMatches));
            return this;
        }

        public final Collection<String> getMedMatches() {
            if (this.medMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.medMatches;
        }

        public final void setMedMatches(Collection<String> medMatches) {
            this.medMatches = ConstrainedStringListCopier.copy(medMatches);
        }

        @Override
        public final Builder medMatches(Collection<String> medMatches) {
            this.medMatches = ConstrainedStringListCopier.copy(medMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medMatches(String ... medMatches) {
            this.medMatches(Arrays.asList(medMatches));
            return this;
        }

        public final Collection<String> getCommunityMatches() {
            if (this.communityMatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.communityMatches;
        }

        public final void setCommunityMatches(Collection<String> communityMatches) {
            this.communityMatches = ConstrainedStringListCopier.copy(communityMatches);
        }

        @Override
        public final Builder communityMatches(Collection<String> communityMatches) {
            this.communityMatches = ConstrainedStringListCopier.copy(communityMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communityMatches(String ... communityMatches) {
            this.communityMatches(Arrays.asList(communityMatches));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoreNetworkRoutingInformationRequest build() {
            return new ListCoreNetworkRoutingInformationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoreNetworkRoutingInformationRequest> {
        public Builder coreNetworkId(String var1);

        public Builder segmentName(String var1);

        public Builder edgeLocation(String var1);

        public Builder nextHopFilters(Map<String, ? extends Collection<String>> var1);

        public Builder localPreferenceMatches(Collection<String> var1);

        public Builder localPreferenceMatches(String ... var1);

        public Builder exactAsPathMatches(Collection<String> var1);

        public Builder exactAsPathMatches(String ... var1);

        public Builder medMatches(Collection<String> var1);

        public Builder medMatches(String ... var1);

        public Builder communityMatches(Collection<String> var1);

        public Builder communityMatches(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

