/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.LinkAssociation;
import software.amazon.awssdk.services.networkmanager.model.LinkAssociationListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLinkAssociationsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetLinkAssociationsResponse> {
    private static final SdkField<List<LinkAssociation>> LINK_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkAssociations").getter(GetLinkAssociationsResponse.getter(GetLinkAssociationsResponse::linkAssociations)).setter(GetLinkAssociationsResponse.setter(Builder::linkAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LinkAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetLinkAssociationsResponse.getter(GetLinkAssociationsResponse::nextToken)).setter(GetLinkAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLinkAssociationsResponse.memberNameToFieldInitializer();
    private final List<LinkAssociation> linkAssociations;
    private final String nextToken;

    private GetLinkAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.linkAssociations = builder.linkAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLinkAssociations() {
        return this.linkAssociations != null && !(this.linkAssociations instanceof SdkAutoConstructList);
    }

    public final List<LinkAssociation> linkAssociations() {
        return this.linkAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkAssociations() ? this.linkAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkAssociationsResponse)) {
            return false;
        }
        GetLinkAssociationsResponse other = (GetLinkAssociationsResponse)((Object)obj);
        return this.hasLinkAssociations() == other.hasLinkAssociations() && Objects.equals(this.linkAssociations(), other.linkAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetLinkAssociationsResponse").add("LinkAssociations", this.hasLinkAssociations() ? this.linkAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkAssociations": {
                return Optional.ofNullable(clazz.cast(this.linkAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LinkAssociations", LINK_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLinkAssociationsResponse, T> g) {
        return obj -> g.apply((GetLinkAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<LinkAssociation> linkAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkAssociationsResponse model) {
            super(model);
            this.linkAssociations(model.linkAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<LinkAssociation.Builder> getLinkAssociations() {
            List<LinkAssociation.Builder> result = LinkAssociationListCopier.copyToBuilder(this.linkAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinkAssociations(Collection<LinkAssociation.BuilderImpl> linkAssociations) {
            this.linkAssociations = LinkAssociationListCopier.copyFromBuilder(linkAssociations);
        }

        @Override
        public final Builder linkAssociations(Collection<LinkAssociation> linkAssociations) {
            this.linkAssociations = LinkAssociationListCopier.copy(linkAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkAssociations(LinkAssociation ... linkAssociations) {
            this.linkAssociations(Arrays.asList(linkAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkAssociations(Consumer<LinkAssociation.Builder> ... linkAssociations) {
            this.linkAssociations(Stream.of(linkAssociations).map(c -> (LinkAssociation)((LinkAssociation.Builder)LinkAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetLinkAssociationsResponse build() {
            return new GetLinkAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLinkAssociationsResponse> {
        public Builder linkAssociations(Collection<LinkAssociation> var1);

        public Builder linkAssociations(LinkAssociation ... var1);

        public Builder linkAssociations(Consumer<LinkAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

