/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkRoute;
import software.amazon.awssdk.services.networkmanager.model.NetworkRouteListCopier;
import software.amazon.awssdk.services.networkmanager.model.RouteTableType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkRoutesResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetNetworkRoutesResponse> {
    private static final SdkField<String> ROUTE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableArn").getter(GetNetworkRoutesResponse.getter(GetNetworkRoutesResponse::routeTableArn)).setter(GetNetworkRoutesResponse.setter(Builder::routeTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableArn").build()}).build();
    private static final SdkField<CoreNetworkSegmentEdgeIdentifier> CORE_NETWORK_SEGMENT_EDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoreNetworkSegmentEdge").getter(GetNetworkRoutesResponse.getter(GetNetworkRoutesResponse::coreNetworkSegmentEdge)).setter(GetNetworkRoutesResponse.setter(Builder::coreNetworkSegmentEdge)).constructor(CoreNetworkSegmentEdgeIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkSegmentEdge").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableType").getter(GetNetworkRoutesResponse.getter(GetNetworkRoutesResponse::routeTableTypeAsString)).setter(GetNetworkRoutesResponse.setter(Builder::routeTableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableType").build()}).build();
    private static final SdkField<Instant> ROUTE_TABLE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RouteTableTimestamp").getter(GetNetworkRoutesResponse.getter(GetNetworkRoutesResponse::routeTableTimestamp)).setter(GetNetworkRoutesResponse.setter(Builder::routeTableTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableTimestamp").build()}).build();
    private static final SdkField<List<NetworkRoute>> NETWORK_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkRoutes").getter(GetNetworkRoutesResponse.getter(GetNetworkRoutesResponse::networkRoutes)).setter(GetNetworkRoutesResponse.setter(Builder::networkRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_ARN_FIELD, CORE_NETWORK_SEGMENT_EDGE_FIELD, ROUTE_TABLE_TYPE_FIELD, ROUTE_TABLE_TIMESTAMP_FIELD, NETWORK_ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNetworkRoutesResponse.memberNameToFieldInitializer();
    private final String routeTableArn;
    private final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;
    private final String routeTableType;
    private final Instant routeTableTimestamp;
    private final List<NetworkRoute> networkRoutes;

    private GetNetworkRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routeTableArn = builder.routeTableArn;
        this.coreNetworkSegmentEdge = builder.coreNetworkSegmentEdge;
        this.routeTableType = builder.routeTableType;
        this.routeTableTimestamp = builder.routeTableTimestamp;
        this.networkRoutes = builder.networkRoutes;
    }

    public final String routeTableArn() {
        return this.routeTableArn;
    }

    public final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge() {
        return this.coreNetworkSegmentEdge;
    }

    public final RouteTableType routeTableType() {
        return RouteTableType.fromValue(this.routeTableType);
    }

    public final String routeTableTypeAsString() {
        return this.routeTableType;
    }

    public final Instant routeTableTimestamp() {
        return this.routeTableTimestamp;
    }

    public final boolean hasNetworkRoutes() {
        return this.networkRoutes != null && !(this.networkRoutes instanceof SdkAutoConstructList);
    }

    public final List<NetworkRoute> networkRoutes() {
        return this.networkRoutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkSegmentEdge());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkRoutes() ? this.networkRoutes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkRoutesResponse)) {
            return false;
        }
        GetNetworkRoutesResponse other = (GetNetworkRoutesResponse)((Object)obj);
        return Objects.equals(this.routeTableArn(), other.routeTableArn()) && Objects.equals(this.coreNetworkSegmentEdge(), other.coreNetworkSegmentEdge()) && Objects.equals(this.routeTableTypeAsString(), other.routeTableTypeAsString()) && Objects.equals(this.routeTableTimestamp(), other.routeTableTimestamp()) && this.hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(this.networkRoutes(), other.networkRoutes());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkRoutesResponse").add("RouteTableArn", (Object)this.routeTableArn()).add("CoreNetworkSegmentEdge", (Object)this.coreNetworkSegmentEdge()).add("RouteTableType", (Object)this.routeTableTypeAsString()).add("RouteTableTimestamp", (Object)this.routeTableTimestamp()).add("NetworkRoutes", this.hasNetworkRoutes() ? this.networkRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTableArn": {
                return Optional.ofNullable(clazz.cast(this.routeTableArn()));
            }
            case "CoreNetworkSegmentEdge": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkSegmentEdge()));
            }
            case "RouteTableType": {
                return Optional.ofNullable(clazz.cast(this.routeTableTypeAsString()));
            }
            case "RouteTableTimestamp": {
                return Optional.ofNullable(clazz.cast(this.routeTableTimestamp()));
            }
            case "NetworkRoutes": {
                return Optional.ofNullable(clazz.cast(this.networkRoutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteTableArn", ROUTE_TABLE_ARN_FIELD);
        map.put("CoreNetworkSegmentEdge", CORE_NETWORK_SEGMENT_EDGE_FIELD);
        map.put("RouteTableType", ROUTE_TABLE_TYPE_FIELD);
        map.put("RouteTableTimestamp", ROUTE_TABLE_TIMESTAMP_FIELD);
        map.put("NetworkRoutes", NETWORK_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkRoutesResponse, T> g) {
        return obj -> g.apply((GetNetworkRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private String routeTableArn;
        private CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;
        private String routeTableType;
        private Instant routeTableTimestamp;
        private List<NetworkRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkRoutesResponse model) {
            super(model);
            this.routeTableArn(model.routeTableArn);
            this.coreNetworkSegmentEdge(model.coreNetworkSegmentEdge);
            this.routeTableType(model.routeTableType);
            this.routeTableTimestamp(model.routeTableTimestamp);
            this.networkRoutes(model.networkRoutes);
        }

        public final String getRouteTableArn() {
            return this.routeTableArn;
        }

        public final void setRouteTableArn(String routeTableArn) {
            this.routeTableArn = routeTableArn;
        }

        @Override
        public final Builder routeTableArn(String routeTableArn) {
            this.routeTableArn = routeTableArn;
            return this;
        }

        public final CoreNetworkSegmentEdgeIdentifier.Builder getCoreNetworkSegmentEdge() {
            return this.coreNetworkSegmentEdge != null ? this.coreNetworkSegmentEdge.toBuilder() : null;
        }

        public final void setCoreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier.BuilderImpl coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge != null ? coreNetworkSegmentEdge.build() : null;
        }

        @Override
        public final Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge;
            return this;
        }

        public final String getRouteTableType() {
            return this.routeTableType;
        }

        public final void setRouteTableType(String routeTableType) {
            this.routeTableType = routeTableType;
        }

        @Override
        public final Builder routeTableType(String routeTableType) {
            this.routeTableType = routeTableType;
            return this;
        }

        @Override
        public final Builder routeTableType(RouteTableType routeTableType) {
            this.routeTableType(routeTableType == null ? null : routeTableType.toString());
            return this;
        }

        public final Instant getRouteTableTimestamp() {
            return this.routeTableTimestamp;
        }

        public final void setRouteTableTimestamp(Instant routeTableTimestamp) {
            this.routeTableTimestamp = routeTableTimestamp;
        }

        @Override
        public final Builder routeTableTimestamp(Instant routeTableTimestamp) {
            this.routeTableTimestamp = routeTableTimestamp;
            return this;
        }

        public final List<NetworkRoute.Builder> getNetworkRoutes() {
            List<NetworkRoute.Builder> result = NetworkRouteListCopier.copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<NetworkRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = NetworkRouteListCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        public final Builder networkRoutes(Collection<NetworkRoute> networkRoutes) {
            this.networkRoutes = NetworkRouteListCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(NetworkRoute ... networkRoutes) {
            this.networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(Consumer<NetworkRoute.Builder> ... networkRoutes) {
            this.networkRoutes(Stream.of(networkRoutes).map(c -> (NetworkRoute)((NetworkRoute.Builder)NetworkRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetNetworkRoutesResponse build() {
            return new GetNetworkRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkRoutesResponse> {
        public Builder routeTableArn(String var1);

        public Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier var1);

        default public Builder coreNetworkSegmentEdge(Consumer<CoreNetworkSegmentEdgeIdentifier.Builder> coreNetworkSegmentEdge) {
            return this.coreNetworkSegmentEdge((CoreNetworkSegmentEdgeIdentifier)((CoreNetworkSegmentEdgeIdentifier.Builder)CoreNetworkSegmentEdgeIdentifier.builder().applyMutation(coreNetworkSegmentEdge)).build());
        }

        public Builder routeTableType(String var1);

        public Builder routeTableType(RouteTableType var1);

        public Builder routeTableTimestamp(Instant var1);

        public Builder networkRoutes(Collection<NetworkRoute> var1);

        public Builder networkRoutes(NetworkRoute ... var1);

        public Builder networkRoutes(Consumer<NetworkRoute.Builder> ... var1);
    }
}

