/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.Bandwidth;
import software.amazon.awssdk.services.networkmanager.model.LinkState;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Link
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Link> {
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(Link.getter(Link::linkId)).setter(Link.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()}).build();
    private static final SdkField<String> LINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkArn").getter(Link.getter(Link::linkArn)).setter(Link.setter(Builder::linkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkArn").build()}).build();
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(Link.getter(Link::globalNetworkId)).setter(Link.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(Link.getter(Link::siteId)).setter(Link.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Link.getter(Link::description)).setter(Link.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Link.getter(Link::type)).setter(Link.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Bandwidth> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bandwidth").getter(Link.getter(Link::bandwidth)).setter(Link.setter(Builder::bandwidth)).constructor(Bandwidth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bandwidth").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(Link.getter(Link::provider)).setter(Link.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Link.getter(Link::createdAt)).setter(Link.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Link.getter(Link::stateAsString)).setter(Link.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Link.getter(Link::tags)).setter(Link.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_ID_FIELD, LINK_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, SITE_ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, BANDWIDTH_FIELD, PROVIDER_FIELD, CREATED_AT_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Link.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String linkId;
    private final String linkArn;
    private final String globalNetworkId;
    private final String siteId;
    private final String description;
    private final String type;
    private final Bandwidth bandwidth;
    private final String provider;
    private final Instant createdAt;
    private final String state;
    private final List<Tag> tags;

    private Link(BuilderImpl builder) {
        this.linkId = builder.linkId;
        this.linkArn = builder.linkArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.siteId = builder.siteId;
        this.description = builder.description;
        this.type = builder.type;
        this.bandwidth = builder.bandwidth;
        this.provider = builder.provider;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final String linkArn() {
        return this.linkArn;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public final String provider() {
        return this.provider;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final LinkState state() {
        return LinkState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link other = (Link)obj;
        return Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.linkArn(), other.linkArn()) && Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Link").add("LinkId", (Object)this.linkId()).add("LinkArn", (Object)this.linkArn()).add("GlobalNetworkId", (Object)this.globalNetworkId()).add("SiteId", (Object)this.siteId()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Bandwidth", (Object)this.bandwidth()).add("Provider", (Object)this.provider()).add("CreatedAt", (Object)this.createdAt()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "LinkArn": {
                return Optional.ofNullable(clazz.cast(this.linkArn()));
            }
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LinkId", LINK_ID_FIELD);
        map.put("LinkArn", LINK_ARN_FIELD);
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("SiteId", SITE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Bandwidth", BANDWIDTH_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Link, T> g) {
        return obj -> g.apply((Link)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String linkId;
        private String linkArn;
        private String globalNetworkId;
        private String siteId;
        private String description;
        private String type;
        private Bandwidth bandwidth;
        private String provider;
        private Instant createdAt;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Link model) {
            this.linkId(model.linkId);
            this.linkArn(model.linkArn);
            this.globalNetworkId(model.globalNetworkId);
            this.siteId(model.siteId);
            this.description(model.description);
            this.type(model.type);
            this.bandwidth(model.bandwidth);
            this.provider(model.provider);
            this.createdAt(model.createdAt);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getLinkArn() {
            return this.linkArn;
        }

        public final void setLinkArn(String linkArn) {
            this.linkArn = linkArn;
        }

        @Override
        public final Builder linkArn(String linkArn) {
            this.linkArn = linkArn;
            return this;
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Bandwidth.Builder getBandwidth() {
            return this.bandwidth != null ? this.bandwidth.toBuilder() : null;
        }

        public final void setBandwidth(Bandwidth.BuilderImpl bandwidth) {
            this.bandwidth = bandwidth != null ? bandwidth.build() : null;
        }

        @Override
        public final Builder bandwidth(Bandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LinkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Link build() {
            return new Link(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Link> {
        public Builder linkId(String var1);

        public Builder linkArn(String var1);

        public Builder globalNetworkId(String var1);

        public Builder siteId(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder bandwidth(Bandwidth var1);

        default public Builder bandwidth(Consumer<Bandwidth.Builder> bandwidth) {
            return this.bandwidth((Bandwidth)((Bandwidth.Builder)Bandwidth.builder().applyMutation(bandwidth)).build());
        }

        public Builder provider(String var1);

        public Builder createdAt(Instant var1);

        public Builder state(String var1);

        public Builder state(LinkState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

