/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayConnectPeerAssociationsRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, GetTransitGatewayConnectPeerAssociationsRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(GetTransitGatewayConnectPeerAssociationsRequest.getter(GetTransitGatewayConnectPeerAssociationsRequest::globalNetworkId)).setter(GetTransitGatewayConnectPeerAssociationsRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<List<String>> TRANSIT_GATEWAY_CONNECT_PEER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayConnectPeerArns").getter(GetTransitGatewayConnectPeerAssociationsRequest.getter(GetTransitGatewayConnectPeerAssociationsRequest::transitGatewayConnectPeerArns)).setter(GetTransitGatewayConnectPeerAssociationsRequest.setter(Builder::transitGatewayConnectPeerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("transitGatewayConnectPeerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetTransitGatewayConnectPeerAssociationsRequest.getter(GetTransitGatewayConnectPeerAssociationsRequest::maxResults)).setter(GetTransitGatewayConnectPeerAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayConnectPeerAssociationsRequest.getter(GetTransitGatewayConnectPeerAssociationsRequest::nextToken)).setter(GetTransitGatewayConnectPeerAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, TRANSIT_GATEWAY_CONNECT_PEER_ARNS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTransitGatewayConnectPeerAssociationsRequest.memberNameToFieldInitializer();
    private final String globalNetworkId;
    private final List<String> transitGatewayConnectPeerArns;
    private final Integer maxResults;
    private final String nextToken;

    private GetTransitGatewayConnectPeerAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.transitGatewayConnectPeerArns = builder.transitGatewayConnectPeerArns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final boolean hasTransitGatewayConnectPeerArns() {
        return this.transitGatewayConnectPeerArns != null && !(this.transitGatewayConnectPeerArns instanceof SdkAutoConstructList);
    }

    public final List<String> transitGatewayConnectPeerArns() {
        return this.transitGatewayConnectPeerArns;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayConnectPeerArns() ? this.transitGatewayConnectPeerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayConnectPeerAssociationsRequest)) {
            return false;
        }
        GetTransitGatewayConnectPeerAssociationsRequest other = (GetTransitGatewayConnectPeerAssociationsRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && this.hasTransitGatewayConnectPeerArns() == other.hasTransitGatewayConnectPeerArns() && Objects.equals(this.transitGatewayConnectPeerArns(), other.transitGatewayConnectPeerArns()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayConnectPeerAssociationsRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("TransitGatewayConnectPeerArns", this.hasTransitGatewayConnectPeerArns() ? this.transitGatewayConnectPeerArns() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "TransitGatewayConnectPeerArns": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnectPeerArns()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("globalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("transitGatewayConnectPeerArns", TRANSIT_GATEWAY_CONNECT_PEER_ARNS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayConnectPeerAssociationsRequest, T> g) {
        return obj -> g.apply((GetTransitGatewayConnectPeerAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private List<String> transitGatewayConnectPeerArns = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayConnectPeerAssociationsRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.transitGatewayConnectPeerArns(model.transitGatewayConnectPeerArns);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final Collection<String> getTransitGatewayConnectPeerArns() {
            if (this.transitGatewayConnectPeerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transitGatewayConnectPeerArns;
        }

        public final void setTransitGatewayConnectPeerArns(Collection<String> transitGatewayConnectPeerArns) {
            this.transitGatewayConnectPeerArns = TransitGatewayConnectPeerArnListCopier.copy(transitGatewayConnectPeerArns);
        }

        @Override
        public final Builder transitGatewayConnectPeerArns(Collection<String> transitGatewayConnectPeerArns) {
            this.transitGatewayConnectPeerArns = TransitGatewayConnectPeerArnListCopier.copy(transitGatewayConnectPeerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeerArns(String ... transitGatewayConnectPeerArns) {
            this.transitGatewayConnectPeerArns(Arrays.asList(transitGatewayConnectPeerArns));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTransitGatewayConnectPeerAssociationsRequest build() {
            return new GetTransitGatewayConnectPeerAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayConnectPeerAssociationsRequest> {
        public Builder globalNetworkId(String var1);

        public Builder transitGatewayConnectPeerArns(Collection<String> var1);

        public Builder transitGatewayConnectPeerArns(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

