/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;

public class GetCustomerGatewayAssociationsIterable
implements SdkIterable<GetCustomerGatewayAssociationsResponse> {
    private final NetworkManagerClient client;
    private final GetCustomerGatewayAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCustomerGatewayAssociationsIterable(NetworkManagerClient client, GetCustomerGatewayAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCustomerGatewayAssociationsResponseFetcher();
    }

    public Iterator<GetCustomerGatewayAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomerGatewayAssociation> customerGatewayAssociations() {
        Function<GetCustomerGatewayAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customerGatewayAssociations() != null) {
                return response.customerGatewayAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCustomerGatewayAssociationsResponseFetcher
    implements SyncPageFetcher<GetCustomerGatewayAssociationsResponse> {
        private GetCustomerGatewayAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetCustomerGatewayAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCustomerGatewayAssociationsResponse nextPage(GetCustomerGatewayAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetCustomerGatewayAssociationsIterable.this.client.getCustomerGatewayAssociations(GetCustomerGatewayAssociationsIterable.this.firstRequest);
            }
            return GetCustomerGatewayAssociationsIterable.this.client.getCustomerGatewayAssociations((GetCustomerGatewayAssociationsRequest)((Object)GetCustomerGatewayAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

