/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkResourceSummary> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegisteredGatewayArn").getter(NetworkResourceSummary.getter(NetworkResourceSummary::registeredGatewayArn)).setter(NetworkResourceSummary.setter(Builder::registeredGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(NetworkResourceSummary.getter(NetworkResourceSummary::resourceArn)).setter(NetworkResourceSummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(NetworkResourceSummary.getter(NetworkResourceSummary::resourceType)).setter(NetworkResourceSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definition").getter(NetworkResourceSummary.getter(NetworkResourceSummary::definition)).setter(NetworkResourceSummary.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> NAME_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameTag").getter(NetworkResourceSummary.getter(NetworkResourceSummary::nameTag)).setter(NetworkResourceSummary.setter(Builder::nameTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameTag").build()}).build();
    private static final SdkField<Boolean> IS_MIDDLEBOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMiddlebox").getter(NetworkResourceSummary.getter(NetworkResourceSummary::isMiddlebox)).setter(NetworkResourceSummary.setter(Builder::isMiddlebox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMiddlebox").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, DEFINITION_FIELD, NAME_TAG_FIELD, IS_MIDDLEBOX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegisteredGatewayArn", REGISTERED_GATEWAY_ARN_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("Definition", DEFINITION_FIELD);
            this.put("NameTag", NAME_TAG_FIELD);
            this.put("IsMiddlebox", IS_MIDDLEBOX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String registeredGatewayArn;
    private final String resourceArn;
    private final String resourceType;
    private final String definition;
    private final String nameTag;
    private final Boolean isMiddlebox;

    private NetworkResourceSummary(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.definition = builder.definition;
        this.nameTag = builder.nameTag;
        this.isMiddlebox = builder.isMiddlebox;
    }

    public final String registeredGatewayArn() {
        return this.registeredGatewayArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String definition() {
        return this.definition;
    }

    public final String nameTag() {
        return this.nameTag;
    }

    public final Boolean isMiddlebox() {
        return this.isMiddlebox;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMiddlebox());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResourceSummary)) {
            return false;
        }
        NetworkResourceSummary other = (NetworkResourceSummary)obj;
        return Objects.equals(this.registeredGatewayArn(), other.registeredGatewayArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.nameTag(), other.nameTag()) && Objects.equals(this.isMiddlebox(), other.isMiddlebox());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkResourceSummary").add("RegisteredGatewayArn", (Object)this.registeredGatewayArn()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceType()).add("Definition", (Object)this.definition()).add("NameTag", (Object)this.nameTag()).add("IsMiddlebox", (Object)this.isMiddlebox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegisteredGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.registeredGatewayArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "NameTag": {
                return Optional.ofNullable(clazz.cast(this.nameTag()));
            }
            case "IsMiddlebox": {
                return Optional.ofNullable(clazz.cast(this.isMiddlebox()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkResourceSummary, T> g) {
        return obj -> g.apply((NetworkResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registeredGatewayArn;
        private String resourceArn;
        private String resourceType;
        private String definition;
        private String nameTag;
        private Boolean isMiddlebox;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResourceSummary model) {
            this.registeredGatewayArn(model.registeredGatewayArn);
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.definition(model.definition);
            this.nameTag(model.nameTag);
            this.isMiddlebox(model.isMiddlebox);
        }

        public final String getRegisteredGatewayArn() {
            return this.registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getNameTag() {
            return this.nameTag;
        }

        public final void setNameTag(String nameTag) {
            this.nameTag = nameTag;
        }

        @Override
        public final Builder nameTag(String nameTag) {
            this.nameTag = nameTag;
            return this;
        }

        public final Boolean getIsMiddlebox() {
            return this.isMiddlebox;
        }

        public final void setIsMiddlebox(Boolean isMiddlebox) {
            this.isMiddlebox = isMiddlebox;
        }

        @Override
        public final Builder isMiddlebox(Boolean isMiddlebox) {
            this.isMiddlebox = isMiddlebox;
            return this;
        }

        public NetworkResourceSummary build() {
            return new NetworkResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkResourceSummary> {
        public Builder registeredGatewayArn(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder definition(String var1);

        public Builder nameTag(String var1);

        public Builder isMiddlebox(Boolean var1);
    }
}

