/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProposedNetworkFunctionGroupChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProposedNetworkFunctionGroupChange> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProposedNetworkFunctionGroupChange.getter(ProposedNetworkFunctionGroupChange::tags)).setter(ProposedNetworkFunctionGroupChange.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> ATTACHMENT_POLICY_RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AttachmentPolicyRuleNumber").getter(ProposedNetworkFunctionGroupChange.getter(ProposedNetworkFunctionGroupChange::attachmentPolicyRuleNumber)).setter(ProposedNetworkFunctionGroupChange.setter(Builder::attachmentPolicyRuleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentPolicyRuleNumber").build()}).build();
    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkFunctionGroupName").getter(ProposedNetworkFunctionGroupChange.getter(ProposedNetworkFunctionGroupChange::networkFunctionGroupName)).setter(ProposedNetworkFunctionGroupChange.setter(Builder::networkFunctionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, ATTACHMENT_POLICY_RULE_NUMBER_FIELD, NETWORK_FUNCTION_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Tags", TAGS_FIELD);
            this.put("AttachmentPolicyRuleNumber", ATTACHMENT_POLICY_RULE_NUMBER_FIELD);
            this.put("NetworkFunctionGroupName", NETWORK_FUNCTION_GROUP_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Tag> tags;
    private final Integer attachmentPolicyRuleNumber;
    private final String networkFunctionGroupName;

    private ProposedNetworkFunctionGroupChange(BuilderImpl builder) {
        this.tags = builder.tags;
        this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer attachmentPolicyRuleNumber() {
        return this.attachmentPolicyRuleNumber;
    }

    public final String networkFunctionGroupName() {
        return this.networkFunctionGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentPolicyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFunctionGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposedNetworkFunctionGroupChange)) {
            return false;
        }
        ProposedNetworkFunctionGroupChange other = (ProposedNetworkFunctionGroupChange)obj;
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.attachmentPolicyRuleNumber(), other.attachmentPolicyRuleNumber()) && Objects.equals(this.networkFunctionGroupName(), other.networkFunctionGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"ProposedNetworkFunctionGroupChange").add("Tags", this.hasTags() ? this.tags() : null).add("AttachmentPolicyRuleNumber", (Object)this.attachmentPolicyRuleNumber()).add("NetworkFunctionGroupName", (Object)this.networkFunctionGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AttachmentPolicyRuleNumber": {
                return Optional.ofNullable(clazz.cast(this.attachmentPolicyRuleNumber()));
            }
            case "NetworkFunctionGroupName": {
                return Optional.ofNullable(clazz.cast(this.networkFunctionGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProposedNetworkFunctionGroupChange, T> g) {
        return obj -> g.apply((ProposedNetworkFunctionGroupChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer attachmentPolicyRuleNumber;
        private String networkFunctionGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProposedNetworkFunctionGroupChange model) {
            this.tags(model.tags);
            this.attachmentPolicyRuleNumber(model.attachmentPolicyRuleNumber);
            this.networkFunctionGroupName(model.networkFunctionGroupName);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getAttachmentPolicyRuleNumber() {
            return this.attachmentPolicyRuleNumber;
        }

        public final void setAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
        }

        @Override
        public final Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        public ProposedNetworkFunctionGroupChange build() {
            return new ProposedNetworkFunctionGroupChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProposedNetworkFunctionGroupChange> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder attachmentPolicyRuleNumber(Integer var1);

        public Builder networkFunctionGroupName(String var1);
    }
}

