/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.ChangeAction;
import software.amazon.awssdk.services.networkmanager.model.ChangeStatus;
import software.amazon.awssdk.services.networkmanager.model.ChangeType;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkChangeEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkChangeEvent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::typeAsString)).setter(CoreNetworkChangeEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::actionAsString)).setter(CoreNetworkChangeEvent.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> IDENTIFIER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierPath").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::identifierPath)).setter(CoreNetworkChangeEvent.setter(Builder::identifierPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierPath").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::eventTime)).setter(CoreNetworkChangeEvent.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::statusAsString)).setter(CoreNetworkChangeEvent.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CoreNetworkChangeEventValues> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Values").getter(CoreNetworkChangeEvent.getter(CoreNetworkChangeEvent::values)).setter(CoreNetworkChangeEvent.setter(Builder::values)).constructor(CoreNetworkChangeEventValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD, IDENTIFIER_PATH_FIELD, EVENT_TIME_FIELD, STATUS_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Action", ACTION_FIELD);
            this.put("IdentifierPath", IDENTIFIER_PATH_FIELD);
            this.put("EventTime", EVENT_TIME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String action;
    private final String identifierPath;
    private final Instant eventTime;
    private final String status;
    private final CoreNetworkChangeEventValues values;

    private CoreNetworkChangeEvent(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
        this.identifierPath = builder.identifierPath;
        this.eventTime = builder.eventTime;
        this.status = builder.status;
        this.values = builder.values;
    }

    public final ChangeType type() {
        return ChangeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String identifierPath() {
        return this.identifierPath;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final ChangeStatus status() {
        return ChangeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CoreNetworkChangeEventValues values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeEvent)) {
            return false;
        }
        CoreNetworkChangeEvent other = (CoreNetworkChangeEvent)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.identifierPath(), other.identifierPath()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkChangeEvent").add("Type", (Object)this.typeAsString()).add("Action", (Object)this.actionAsString()).add("IdentifierPath", (Object)this.identifierPath()).add("EventTime", (Object)this.eventTime()).add("Status", (Object)this.statusAsString()).add("Values", (Object)this.values()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "IdentifierPath": {
                return Optional.ofNullable(clazz.cast(this.identifierPath()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeEvent, T> g) {
        return obj -> g.apply((CoreNetworkChangeEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String action;
        private String identifierPath;
        private Instant eventTime;
        private String status;
        private CoreNetworkChangeEventValues values;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeEvent model) {
            this.type(model.type);
            this.action(model.action);
            this.identifierPath(model.identifierPath);
            this.eventTime(model.eventTime);
            this.status(model.status);
            this.values(model.values);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIdentifierPath() {
            return this.identifierPath;
        }

        public final void setIdentifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
        }

        @Override
        public final Builder identifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CoreNetworkChangeEventValues.Builder getValues() {
            return this.values != null ? this.values.toBuilder() : null;
        }

        public final void setValues(CoreNetworkChangeEventValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(CoreNetworkChangeEventValues values) {
            this.values = values;
            return this;
        }

        public CoreNetworkChangeEvent build() {
            return new CoreNetworkChangeEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkChangeEvent> {
        public Builder type(String var1);

        public Builder type(ChangeType var1);

        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder identifierPath(String var1);

        public Builder eventTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangeStatus var1);

        public Builder values(CoreNetworkChangeEventValues var1);

        default public Builder values(Consumer<CoreNetworkChangeEventValues.Builder> values) {
            return this.values((CoreNetworkChangeEventValues)((CoreNetworkChangeEventValues.Builder)CoreNetworkChangeEventValues.builder().applyMutation(values)).build());
        }
    }
}

