/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectPeerErrorCode {
    EDGE_LOCATION_NO_FREE_IPS("EDGE_LOCATION_NO_FREE_IPS"),
    EDGE_LOCATION_PEER_DUPLICATE("EDGE_LOCATION_PEER_DUPLICATE"),
    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),
    IP_OUTSIDE_SUBNET_CIDR_RANGE("IP_OUTSIDE_SUBNET_CIDR_RANGE"),
    INVALID_INSIDE_CIDR_BLOCK("INVALID_INSIDE_CIDR_BLOCK"),
    NO_ASSOCIATED_CIDR_BLOCK("NO_ASSOCIATED_CIDR_BLOCK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectPeerErrorCode> VALUE_MAP;
    private final String value;

    private ConnectPeerErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectPeerErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectPeerErrorCode> knownValues() {
        EnumSet<ConnectPeerErrorCode> knownValues = EnumSet.allOf(ConnectPeerErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectPeerErrorCode.class, ConnectPeerErrorCode::toString);
    }
}

