/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.ExternalRegionCodeListCopier;
import software.amazon.awssdk.services.networkmanager.model.ServiceInsertionAction;
import software.amazon.awssdk.services.networkmanager.model.ServiceInsertionActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkChangeValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkChangeValues> {
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::segmentName)).setter(CoreNetworkChangeValues.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final SdkField<String> NETWORK_FUNCTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkFunctionGroupName").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::networkFunctionGroupName)).setter(CoreNetworkChangeValues.setter(Builder::networkFunctionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroupName").build()}).build();
    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeLocations").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::edgeLocations)).setter(CoreNetworkChangeValues.setter(Builder::edgeLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Asn").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::asn)).setter(CoreNetworkChangeValues.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::cidr)).setter(CoreNetworkChangeValues.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()}).build();
    private static final SdkField<String> DESTINATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIdentifier").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::destinationIdentifier)).setter(CoreNetworkChangeValues.setter(Builder::destinationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIdentifier").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::insideCidrBlocks)).setter(CoreNetworkChangeValues.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SHARED_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedSegments").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::sharedSegments)).setter(CoreNetworkChangeValues.setter(Builder::sharedSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceInsertionAction>> SERVICE_INSERTION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceInsertionActions").getter(CoreNetworkChangeValues.getter(CoreNetworkChangeValues::serviceInsertionActions)).setter(CoreNetworkChangeValues.setter(Builder::serviceInsertionActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceInsertionActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceInsertionAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_NAME_FIELD, NETWORK_FUNCTION_GROUP_NAME_FIELD, EDGE_LOCATIONS_FIELD, ASN_FIELD, CIDR_FIELD, DESTINATION_IDENTIFIER_FIELD, INSIDE_CIDR_BLOCKS_FIELD, SHARED_SEGMENTS_FIELD, SERVICE_INSERTION_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String segmentName;
    private final String networkFunctionGroupName;
    private final List<String> edgeLocations;
    private final Long asn;
    private final String cidr;
    private final String destinationIdentifier;
    private final List<String> insideCidrBlocks;
    private final List<String> sharedSegments;
    private final List<ServiceInsertionAction> serviceInsertionActions;

    private CoreNetworkChangeValues(BuilderImpl builder) {
        this.segmentName = builder.segmentName;
        this.networkFunctionGroupName = builder.networkFunctionGroupName;
        this.edgeLocations = builder.edgeLocations;
        this.asn = builder.asn;
        this.cidr = builder.cidr;
        this.destinationIdentifier = builder.destinationIdentifier;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.sharedSegments = builder.sharedSegments;
        this.serviceInsertionActions = builder.serviceInsertionActions;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public final String networkFunctionGroupName() {
        return this.networkFunctionGroupName;
    }

    public final boolean hasEdgeLocations() {
        return this.edgeLocations != null && !(this.edgeLocations instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLocations() {
        return this.edgeLocations;
    }

    public final Long asn() {
        return this.asn;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String destinationIdentifier() {
        return this.destinationIdentifier;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public final boolean hasSharedSegments() {
        return this.sharedSegments != null && !(this.sharedSegments instanceof SdkAutoConstructList);
    }

    public final List<String> sharedSegments() {
        return this.sharedSegments;
    }

    public final boolean hasServiceInsertionActions() {
        return this.serviceInsertionActions != null && !(this.serviceInsertionActions instanceof SdkAutoConstructList);
    }

    public final List<ServiceInsertionAction> serviceInsertionActions() {
        return this.serviceInsertionActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFunctionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLocations() ? this.edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedSegments() ? this.sharedSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceInsertionActions() ? this.serviceInsertionActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeValues)) {
            return false;
        }
        CoreNetworkChangeValues other = (CoreNetworkChangeValues)obj;
        return Objects.equals(this.segmentName(), other.segmentName()) && Objects.equals(this.networkFunctionGroupName(), other.networkFunctionGroupName()) && this.hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(this.edgeLocations(), other.edgeLocations()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.destinationIdentifier(), other.destinationIdentifier()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks()) && this.hasSharedSegments() == other.hasSharedSegments() && Objects.equals(this.sharedSegments(), other.sharedSegments()) && this.hasServiceInsertionActions() == other.hasServiceInsertionActions() && Objects.equals(this.serviceInsertionActions(), other.serviceInsertionActions());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkChangeValues").add("SegmentName", (Object)this.segmentName()).add("NetworkFunctionGroupName", (Object)this.networkFunctionGroupName()).add("EdgeLocations", this.hasEdgeLocations() ? this.edgeLocations() : null).add("Asn", (Object)this.asn()).add("Cidr", (Object)this.cidr()).add("DestinationIdentifier", (Object)this.destinationIdentifier()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).add("SharedSegments", this.hasSharedSegments() ? this.sharedSegments() : null).add("ServiceInsertionActions", this.hasServiceInsertionActions() ? this.serviceInsertionActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
            case "NetworkFunctionGroupName": {
                return Optional.ofNullable(clazz.cast(this.networkFunctionGroupName()));
            }
            case "EdgeLocations": {
                return Optional.ofNullable(clazz.cast(this.edgeLocations()));
            }
            case "Asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "DestinationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.destinationIdentifier()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
            case "SharedSegments": {
                return Optional.ofNullable(clazz.cast(this.sharedSegments()));
            }
            case "ServiceInsertionActions": {
                return Optional.ofNullable(clazz.cast(this.serviceInsertionActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeValues, T> g) {
        return obj -> g.apply((CoreNetworkChangeValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String segmentName;
        private String networkFunctionGroupName;
        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();
        private Long asn;
        private String cidr;
        private String destinationIdentifier;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private List<String> sharedSegments = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceInsertionAction> serviceInsertionActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeValues model) {
            this.segmentName(model.segmentName);
            this.networkFunctionGroupName(model.networkFunctionGroupName);
            this.edgeLocations(model.edgeLocations);
            this.asn(model.asn);
            this.cidr(model.cidr);
            this.destinationIdentifier(model.destinationIdentifier);
            this.insideCidrBlocks(model.insideCidrBlocks);
            this.sharedSegments(model.sharedSegments);
            this.serviceInsertionActions(model.serviceInsertionActions);
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        public final void setNetworkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
        }

        @Override
        public final Builder networkFunctionGroupName(String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (this.edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String ... edgeLocations) {
            this.edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final Long getAsn() {
            return this.asn;
        }

        public final void setAsn(Long asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getDestinationIdentifier() {
            return this.destinationIdentifier;
        }

        public final void setDestinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
        }

        @Override
        public final Builder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final Collection<String> getSharedSegments() {
            if (this.sharedSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedSegments;
        }

        public final void setSharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
        }

        @Override
        public final Builder sharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedSegments(String ... sharedSegments) {
            this.sharedSegments(Arrays.asList(sharedSegments));
            return this;
        }

        public final List<ServiceInsertionAction.Builder> getServiceInsertionActions() {
            List<ServiceInsertionAction.Builder> result = ServiceInsertionActionListCopier.copyToBuilder(this.serviceInsertionActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceInsertionActions(Collection<ServiceInsertionAction.BuilderImpl> serviceInsertionActions) {
            this.serviceInsertionActions = ServiceInsertionActionListCopier.copyFromBuilder(serviceInsertionActions);
        }

        @Override
        public final Builder serviceInsertionActions(Collection<ServiceInsertionAction> serviceInsertionActions) {
            this.serviceInsertionActions = ServiceInsertionActionListCopier.copy(serviceInsertionActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInsertionActions(ServiceInsertionAction ... serviceInsertionActions) {
            this.serviceInsertionActions(Arrays.asList(serviceInsertionActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInsertionActions(Consumer<ServiceInsertionAction.Builder> ... serviceInsertionActions) {
            this.serviceInsertionActions(Stream.of(serviceInsertionActions).map(c -> (ServiceInsertionAction)((ServiceInsertionAction.Builder)ServiceInsertionAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CoreNetworkChangeValues build() {
            return new CoreNetworkChangeValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkChangeValues> {
        public Builder segmentName(String var1);

        public Builder networkFunctionGroupName(String var1);

        public Builder edgeLocations(Collection<String> var1);

        public Builder edgeLocations(String ... var1);

        public Builder asn(Long var1);

        public Builder cidr(String var1);

        public Builder destinationIdentifier(String var1);

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);

        public Builder sharedSegments(Collection<String> var1);

        public Builder sharedSegments(String ... var1);

        public Builder serviceInsertionActions(Collection<ServiceInsertionAction> var1);

        public Builder serviceInsertionActions(ServiceInsertionAction ... var1);

        public Builder serviceInsertionActions(Consumer<ServiceInsertionAction.Builder> ... var1);
    }
}

