/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.Site;

public class GetSitesIterable
implements SdkIterable<GetSitesResponse> {
    private final NetworkManagerClient client;
    private final GetSitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSitesIterable(NetworkManagerClient client, GetSitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSitesResponseFetcher();
    }

    public Iterator<GetSitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Site> sites() {
        Function<GetSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sites() != null) {
                return response.sites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSitesResponseFetcher
    implements SyncPageFetcher<GetSitesResponse> {
        private GetSitesResponseFetcher() {
        }

        public boolean hasNextPage(GetSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSitesResponse nextPage(GetSitesResponse previousPage) {
            if (previousPage == null) {
                return GetSitesIterable.this.client.getSites(GetSitesIterable.this.firstRequest);
            }
            return GetSitesIterable.this.client.getSites((GetSitesRequest)((Object)GetSitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

