/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfigurationListCopier;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.TunnelProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectPeerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectPeerConfiguration> {
    private static final SdkField<String> CORE_NETWORK_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkAddress").getter(ConnectPeerConfiguration.getter(ConnectPeerConfiguration::coreNetworkAddress)).setter(ConnectPeerConfiguration.setter(Builder::coreNetworkAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(ConnectPeerConfiguration.getter(ConnectPeerConfiguration::peerAddress)).setter(ConnectPeerConfiguration.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(ConnectPeerConfiguration.getter(ConnectPeerConfiguration::insideCidrBlocks)).setter(ConnectPeerConfiguration.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(ConnectPeerConfiguration.getter(ConnectPeerConfiguration::protocolAsString)).setter(ConnectPeerConfiguration.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<List<ConnectPeerBgpConfiguration>> BGP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BgpConfigurations").getter(ConnectPeerConfiguration.getter(ConnectPeerConfiguration::bgpConfigurations)).setter(ConnectPeerConfiguration.setter(Builder::bgpConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectPeerBgpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ADDRESS_FIELD, PEER_ADDRESS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, PROTOCOL_FIELD, BGP_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String coreNetworkAddress;
    private final String peerAddress;
    private final List<String> insideCidrBlocks;
    private final String protocol;
    private final List<ConnectPeerBgpConfiguration> bgpConfigurations;

    private ConnectPeerConfiguration(BuilderImpl builder) {
        this.coreNetworkAddress = builder.coreNetworkAddress;
        this.peerAddress = builder.peerAddress;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.protocol = builder.protocol;
        this.bgpConfigurations = builder.bgpConfigurations;
    }

    public final String coreNetworkAddress() {
        return this.coreNetworkAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public final TunnelProtocol protocol() {
        return TunnelProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasBgpConfigurations() {
        return this.bgpConfigurations != null && !(this.bgpConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ConnectPeerBgpConfiguration> bgpConfigurations() {
        return this.bgpConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpConfigurations() ? this.bgpConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerConfiguration)) {
            return false;
        }
        ConnectPeerConfiguration other = (ConnectPeerConfiguration)obj;
        return Objects.equals(this.coreNetworkAddress(), other.coreNetworkAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasBgpConfigurations() == other.hasBgpConfigurations() && Objects.equals(this.bgpConfigurations(), other.bgpConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectPeerConfiguration").add("CoreNetworkAddress", (Object)this.coreNetworkAddress()).add("PeerAddress", (Object)this.peerAddress()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).add("Protocol", (Object)this.protocolAsString()).add("BgpConfigurations", this.hasBgpConfigurations() ? this.bgpConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkAddress": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "BgpConfigurations": {
                return Optional.ofNullable(clazz.cast(this.bgpConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerConfiguration, T> g) {
        return obj -> g.apply((ConnectPeerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkAddress;
        private String peerAddress;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private List<ConnectPeerBgpConfiguration> bgpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerConfiguration model) {
            this.coreNetworkAddress(model.coreNetworkAddress);
            this.peerAddress(model.peerAddress);
            this.insideCidrBlocks(model.insideCidrBlocks);
            this.protocol(model.protocol);
            this.bgpConfigurations(model.bgpConfigurations);
        }

        public final String getCoreNetworkAddress() {
            return this.coreNetworkAddress;
        }

        public final void setCoreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
        }

        @Override
        public final Builder coreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TunnelProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<ConnectPeerBgpConfiguration.Builder> getBgpConfigurations() {
            List<ConnectPeerBgpConfiguration.Builder> result = ConnectPeerBgpConfigurationListCopier.copyToBuilder(this.bgpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpConfigurations(Collection<ConnectPeerBgpConfiguration.BuilderImpl> bgpConfigurations) {
            this.bgpConfigurations = ConnectPeerBgpConfigurationListCopier.copyFromBuilder(bgpConfigurations);
        }

        @Override
        public final Builder bgpConfigurations(Collection<ConnectPeerBgpConfiguration> bgpConfigurations) {
            this.bgpConfigurations = ConnectPeerBgpConfigurationListCopier.copy(bgpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(ConnectPeerBgpConfiguration ... bgpConfigurations) {
            this.bgpConfigurations(Arrays.asList(bgpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(Consumer<ConnectPeerBgpConfiguration.Builder> ... bgpConfigurations) {
            this.bgpConfigurations(Stream.of(bgpConfigurations).map(c -> (ConnectPeerBgpConfiguration)((ConnectPeerBgpConfiguration.Builder)ConnectPeerBgpConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConnectPeerConfiguration build() {
            return new ConnectPeerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectPeerConfiguration> {
        public Builder coreNetworkAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);

        public Builder protocol(String var1);

        public Builder protocol(TunnelProtocol var1);

        public Builder bgpConfigurations(Collection<ConnectPeerBgpConfiguration> var1);

        public Builder bgpConfigurations(ConnectPeerBgpConfiguration ... var1);

        public Builder bgpConfigurations(Consumer<ConnectPeerBgpConfiguration.Builder> ... var1);
    }
}

