/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse;
import software.amazon.awssdk.services.networkmanager.model.Peering;

public class ListPeeringsPublisher
implements SdkPublisher<ListPeeringsResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListPeeringsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPeeringsPublisher(NetworkManagerAsyncClient client, ListPeeringsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPeeringsPublisher(NetworkManagerAsyncClient client, ListPeeringsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPeeringsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPeeringsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Peering> peerings() {
        Function<ListPeeringsResponse, Iterator> getIterator = response -> {
            if (response != null && response.peerings() != null) {
                return response.peerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPeeringsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPeeringsResponseFetcher
    implements AsyncPageFetcher<ListPeeringsResponse> {
        private ListPeeringsResponseFetcher() {
        }

        public boolean hasNextPage(ListPeeringsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPeeringsResponse> nextPage(ListPeeringsResponse previousPage) {
            if (previousPage == null) {
                return ListPeeringsPublisher.this.client.listPeerings(ListPeeringsPublisher.this.firstRequest);
            }
            return ListPeeringsPublisher.this.client.listPeerings((ListPeeringsRequest)((Object)ListPeeringsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

