/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest;
import software.amazon.awssdk.services.networkmanager.model.ListConnectPeersResponse;

public class ListConnectPeersPublisher
implements SdkPublisher<ListConnectPeersResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListConnectPeersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectPeersPublisher(NetworkManagerAsyncClient client, ListConnectPeersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectPeersPublisher(NetworkManagerAsyncClient client, ListConnectPeersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectPeersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectPeersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectPeerSummary> connectPeers() {
        Function<ListConnectPeersResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectPeers() != null) {
                return response.connectPeers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectPeersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectPeersResponseFetcher
    implements AsyncPageFetcher<ListConnectPeersResponse> {
        private ListConnectPeersResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectPeersResponse> nextPage(ListConnectPeersResponse previousPage) {
            if (previousPage == null) {
                return ListConnectPeersPublisher.this.client.listConnectPeers(ListConnectPeersPublisher.this.firstRequest);
            }
            return ListConnectPeersPublisher.this.client.listConnectPeers((ListConnectPeersRequest)((Object)ListConnectPeersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

