/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network change event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkChangeEventValues implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkChangeEventValues.Builder, CoreNetworkChangeEventValues> {
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(CoreNetworkChangeEventValues::edgeLocation))
            .setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(CoreNetworkChangeEventValues::segmentName))
            .setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(CoreNetworkChangeEventValues::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(CoreNetworkChangeEventValues::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_LOCATION_FIELD,
            SEGMENT_NAME_FIELD, ATTACHMENT_ID_FIELD, CIDR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String edgeLocation;

    private final String segmentName;

    private final String attachmentId;

    private final String cidr;

    private CoreNetworkChangeEventValues(BuilderImpl builder) {
        this.edgeLocation = builder.edgeLocation;
        this.segmentName = builder.segmentName;
        this.attachmentId = builder.attachmentId;
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * The edge location for the core network change event.
     * </p>
     * 
     * @return The edge location for the core network change event.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The segment name if the change event is associated with a segment.
     * </p>
     * 
     * @return The segment name if the change event is associated with a segment.
     */
    public final String segmentName() {
        return segmentName;
    }

    /**
     * <p>
     * The ID of the attachment if the change event is associated with an attachment.
     * </p>
     * 
     * @return The ID of the attachment if the change event is associated with an attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * For a <code>STATIC_ROUTE</code> event, this is the IP address.
     * </p>
     * 
     * @return For a <code>STATIC_ROUTE</code> event, this is the IP address.
     */
    public final String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeEventValues)) {
            return false;
        }
        CoreNetworkChangeEventValues other = (CoreNetworkChangeEventValues) obj;
        return Objects.equals(edgeLocation(), other.edgeLocation()) && Objects.equals(segmentName(), other.segmentName())
                && Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(cidr(), other.cidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkChangeEventValues").add("EdgeLocation", edgeLocation())
                .add("SegmentName", segmentName()).add("AttachmentId", attachmentId()).add("Cidr", cidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeEventValues, T> g) {
        return obj -> g.apply((CoreNetworkChangeEventValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkChangeEventValues> {
        /**
         * <p>
         * The edge location for the core network change event.
         * </p>
         * 
         * @param edgeLocation
         *        The edge location for the core network change event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The segment name if the change event is associated with a segment.
         * </p>
         * 
         * @param segmentName
         *        The segment name if the change event is associated with a segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);

        /**
         * <p>
         * The ID of the attachment if the change event is associated with an attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment if the change event is associated with an attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * For a <code>STATIC_ROUTE</code> event, this is the IP address.
         * </p>
         * 
         * @param cidr
         *        For a <code>STATIC_ROUTE</code> event, this is the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    static final class BuilderImpl implements Builder {
        private String edgeLocation;

        private String segmentName;

        private String attachmentId;

        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeEventValues model) {
            edgeLocation(model.edgeLocation);
            segmentName(model.segmentName);
            attachmentId(model.attachmentId);
            cidr(model.cidr);
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        @Override
        public CoreNetworkChangeEventValues build() {
            return new CoreNetworkChangeEventValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
