/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.PeeringState;
import software.amazon.awssdk.services.networkmanager.model.PeeringType;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Peering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Peering> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(Peering.getter(Peering::coreNetworkId)).setter(Peering.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkArn").getter(Peering.getter(Peering::coreNetworkArn)).setter(Peering.setter(Builder::coreNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()}).build();
    private static final SdkField<String> PEERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeeringId").getter(Peering.getter(Peering::peeringId)).setter(Peering.setter(Builder::peeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(Peering.getter(Peering::ownerAccountId)).setter(Peering.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> PEERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeeringType").getter(Peering.getter(Peering::peeringTypeAsString)).setter(Peering.setter(Builder::peeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Peering.getter(Peering::stateAsString)).setter(Peering.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(Peering.getter(Peering::edgeLocation)).setter(Peering.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Peering.getter(Peering::resourceArn)).setter(Peering.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Peering.getter(Peering::tags)).setter(Peering.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Peering.getter(Peering::createdAt)).setter(Peering.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, CORE_NETWORK_ARN_FIELD, PEERING_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, PEERING_TYPE_FIELD, STATE_FIELD, EDGE_LOCATION_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final String coreNetworkArn;
    private final String peeringId;
    private final String ownerAccountId;
    private final String peeringType;
    private final String state;
    private final String edgeLocation;
    private final String resourceArn;
    private final List<Tag> tags;
    private final Instant createdAt;

    private Peering(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.peeringId = builder.peeringId;
        this.ownerAccountId = builder.ownerAccountId;
        this.peeringType = builder.peeringType;
        this.state = builder.state;
        this.edgeLocation = builder.edgeLocation;
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String coreNetworkArn() {
        return this.coreNetworkArn;
    }

    public final String peeringId() {
        return this.peeringId;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final PeeringType peeringType() {
        return PeeringType.fromValue(this.peeringType);
    }

    public final String peeringTypeAsString() {
        return this.peeringType;
    }

    public final PeeringState state() {
        return PeeringState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Peering)) {
            return false;
        }
        Peering other = (Peering)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(this.peeringId(), other.peeringId()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.peeringTypeAsString(), other.peeringTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.edgeLocation(), other.edgeLocation()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"Peering").add("CoreNetworkId", (Object)this.coreNetworkId()).add("CoreNetworkArn", (Object)this.coreNetworkArn()).add("PeeringId", (Object)this.peeringId()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("PeeringType", (Object)this.peeringTypeAsString()).add("State", (Object)this.stateAsString()).add("EdgeLocation", (Object)this.edgeLocation()).add("ResourceArn", (Object)this.resourceArn()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "CoreNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkArn()));
            }
            case "PeeringId": {
                return Optional.ofNullable(clazz.cast(this.peeringId()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "PeeringType": {
                return Optional.ofNullable(clazz.cast(this.peeringTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Peering, T> g) {
        return obj -> g.apply((Peering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String coreNetworkArn;
        private String peeringId;
        private String ownerAccountId;
        private String peeringType;
        private String state;
        private String edgeLocation;
        private String resourceArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Peering model) {
            this.coreNetworkId(model.coreNetworkId);
            this.coreNetworkArn(model.coreNetworkArn);
            this.peeringId(model.peeringId);
            this.ownerAccountId(model.ownerAccountId);
            this.peeringType(model.peeringType);
            this.state(model.state);
            this.edgeLocation(model.edgeLocation);
            this.resourceArn(model.resourceArn);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getPeeringId() {
            return this.peeringId;
        }

        public final void setPeeringId(String peeringId) {
            this.peeringId = peeringId;
        }

        @Override
        public final Builder peeringId(String peeringId) {
            this.peeringId = peeringId;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getPeeringType() {
            return this.peeringType;
        }

        public final void setPeeringType(String peeringType) {
            this.peeringType = peeringType;
        }

        @Override
        public final Builder peeringType(String peeringType) {
            this.peeringType = peeringType;
            return this;
        }

        @Override
        public final Builder peeringType(PeeringType peeringType) {
            this.peeringType(peeringType == null ? null : peeringType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PeeringState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Peering build() {
            return new Peering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Peering> {
        public Builder coreNetworkId(String var1);

        public Builder coreNetworkArn(String var1);

        public Builder peeringId(String var1);

        public Builder ownerAccountId(String var1);

        public Builder peeringType(String var1);

        public Builder peeringType(PeeringType var1);

        public Builder state(String var1);

        public Builder state(PeeringState var1);

        public Builder edgeLocation(String var1);

        public Builder resourceArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdAt(Instant var1);
    }
}

