/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse;

public class GetCoreNetworkChangeEventsPublisher
implements SdkPublisher<GetCoreNetworkChangeEventsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetCoreNetworkChangeEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCoreNetworkChangeEventsPublisher(NetworkManagerAsyncClient client, GetCoreNetworkChangeEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCoreNetworkChangeEventsPublisher(NetworkManagerAsyncClient client, GetCoreNetworkChangeEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCoreNetworkChangeEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCoreNetworkChangeEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreNetworkChangeEvent> coreNetworkChangeEvents() {
        Function<GetCoreNetworkChangeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkChangeEvents() != null) {
                return response.coreNetworkChangeEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCoreNetworkChangeEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCoreNetworkChangeEventsResponseFetcher
    implements AsyncPageFetcher<GetCoreNetworkChangeEventsResponse> {
        private GetCoreNetworkChangeEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetCoreNetworkChangeEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCoreNetworkChangeEventsResponse> nextPage(GetCoreNetworkChangeEventsResponse previousPage) {
            if (previousPage == null) {
                return GetCoreNetworkChangeEventsPublisher.this.client.getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsPublisher.this.firstRequest);
            }
            return GetCoreNetworkChangeEventsPublisher.this.client.getCoreNetworkChangeEvents((GetCoreNetworkChangeEventsRequest)((Object)GetCoreNetworkChangeEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

