/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.ConflictException;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.DisassociateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.GetSitesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetSitesResponse;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.InternalServerException;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerException;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest;
import software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse;
import software.amazon.awssdk.services.networkmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.networkmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.ThrottlingException;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest;
import software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse;
import software.amazon.awssdk.services.networkmanager.model.ValidationException;
import software.amazon.awssdk.services.networkmanager.paginators.DescribeGlobalNetworksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetCustomerGatewayAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetDevicesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinkAssociationsIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetLinksIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetSitesIterable;
import software.amazon.awssdk.services.networkmanager.paginators.GetTransitGatewayRegistrationsIterable;
import software.amazon.awssdk.services.networkmanager.transform.AssociateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.AssociateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.CreateSiteRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeleteSiteRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DeregisterTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DescribeGlobalNetworksRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DisassociateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.DisassociateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetCustomerGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetDevicesRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetLinkAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetLinksRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetSitesRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.GetTransitGatewayRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.RegisterTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateDeviceRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateGlobalNetworkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateLinkRequestMarshaller;
import software.amazon.awssdk.services.networkmanager.transform.UpdateSiteRequestMarshaller;

@SdkInternalApi
final class DefaultNetworkManagerClient
implements NetworkManagerClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkManagerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "networkmanager";
    }

    @Override
    public AssociateCustomerGatewayResponse associateCustomerGateway(AssociateCustomerGatewayRequest associateCustomerGatewayRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateCustomerGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateCustomerGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateCustomerGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateCustomerGatewayRequest).withMarshaller((Marshaller)new AssociateCustomerGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AssociateLinkResponse associateLink(AssociateLinkRequest associateLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateLinkRequest).withMarshaller((Marshaller)new AssociateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDeviceResponse createDevice(CreateDeviceRequest createDeviceRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeviceRequest).withMarshaller((Marshaller)new CreateDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGlobalNetworkResponse createGlobalNetwork(CreateGlobalNetworkRequest createGlobalNetworkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGlobalNetworkRequest).withMarshaller((Marshaller)new CreateGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateLinkResponse createLink(CreateLinkRequest createLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLinkRequest).withMarshaller((Marshaller)new CreateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSiteResponse createSite(CreateSiteRequest createSiteRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSiteRequest).withMarshaller((Marshaller)new CreateSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeviceRequest).withMarshaller((Marshaller)new DeleteDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteGlobalNetworkResponse deleteGlobalNetwork(DeleteGlobalNetworkRequest deleteGlobalNetworkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGlobalNetworkRequest).withMarshaller((Marshaller)new DeleteGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteLinkResponse deleteLink(DeleteLinkRequest deleteLinkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLinkRequest).withMarshaller((Marshaller)new DeleteLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSiteResponse deleteSite(DeleteSiteRequest deleteSiteRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSiteRequest).withMarshaller((Marshaller)new DeleteSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeregisterTransitGatewayResponse deregisterTransitGateway(DeregisterTransitGatewayRequest deregisterTransitGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterTransitGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeregisterTransitGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTransitGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterTransitGatewayRequest).withMarshaller((Marshaller)new DeregisterTransitGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGlobalNetworksResponse describeGlobalNetworks(DescribeGlobalNetworksRequest describeGlobalNetworksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalNetworksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGlobalNetworksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalNetworks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGlobalNetworksRequest).withMarshaller((Marshaller)new DescribeGlobalNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGlobalNetworksIterable describeGlobalNetworksPaginator(DescribeGlobalNetworksRequest describeGlobalNetworksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new DescribeGlobalNetworksIterable(this, this.applyPaginatorUserAgent(describeGlobalNetworksRequest));
    }

    @Override
    public DisassociateCustomerGatewayResponse disassociateCustomerGateway(DisassociateCustomerGatewayRequest disassociateCustomerGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateCustomerGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateCustomerGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateCustomerGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateCustomerGatewayRequest).withMarshaller((Marshaller)new DisassociateCustomerGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateLinkResponse disassociateLink(DisassociateLinkRequest disassociateLinkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateLinkRequest).withMarshaller((Marshaller)new DisassociateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCustomerGatewayAssociationsResponse getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCustomerGatewayAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCustomerGatewayAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomerGatewayAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCustomerGatewayAssociationsRequest).withMarshaller((Marshaller)new GetCustomerGatewayAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCustomerGatewayAssociationsIterable getCustomerGatewayAssociationsPaginator(GetCustomerGatewayAssociationsRequest getCustomerGatewayAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetCustomerGatewayAssociationsIterable(this, this.applyPaginatorUserAgent(getCustomerGatewayAssociationsRequest));
    }

    @Override
    public GetDevicesResponse getDevices(GetDevicesRequest getDevicesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDevicesRequest).withMarshaller((Marshaller)new GetDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDevicesIterable getDevicesPaginator(GetDevicesRequest getDevicesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetDevicesIterable(this, this.applyPaginatorUserAgent(getDevicesRequest));
    }

    @Override
    public GetLinkAssociationsResponse getLinkAssociations(GetLinkAssociationsRequest getLinkAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetLinkAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLinkAssociationsRequest).withMarshaller((Marshaller)new GetLinkAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetLinkAssociationsIterable getLinkAssociationsPaginator(GetLinkAssociationsRequest getLinkAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetLinkAssociationsIterable(this, this.applyPaginatorUserAgent(getLinkAssociationsRequest));
    }

    @Override
    public GetLinksResponse getLinks(GetLinksRequest getLinksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetLinksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLinksRequest).withMarshaller((Marshaller)new GetLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetLinksIterable getLinksPaginator(GetLinksRequest getLinksRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetLinksIterable(this, this.applyPaginatorUserAgent(getLinksRequest));
    }

    @Override
    public GetSitesResponse getSites(GetSitesRequest getSitesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSitesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSitesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSites").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSitesRequest).withMarshaller((Marshaller)new GetSitesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSitesIterable getSitesPaginator(GetSitesRequest getSitesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetSitesIterable(this, this.applyPaginatorUserAgent(getSitesRequest));
    }

    @Override
    public GetTransitGatewayRegistrationsResponse getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTransitGatewayRegistrationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetTransitGatewayRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTransitGatewayRegistrations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTransitGatewayRegistrationsRequest).withMarshaller((Marshaller)new GetTransitGatewayRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetTransitGatewayRegistrationsIterable getTransitGatewayRegistrationsPaginator(GetTransitGatewayRegistrationsRequest getTransitGatewayRegistrationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        return new GetTransitGatewayRegistrationsIterable(this, this.applyPaginatorUserAgent(getTransitGatewayRegistrationsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterTransitGatewayResponse registerTransitGateway(RegisterTransitGatewayRequest registerTransitGatewayRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterTransitGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterTransitGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTransitGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerTransitGatewayRequest).withMarshaller((Marshaller)new RegisterTransitGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceRequest).withMarshaller((Marshaller)new UpdateDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateGlobalNetworkResponse updateGlobalNetwork(UpdateGlobalNetworkRequest updateGlobalNetworkRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalNetworkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateGlobalNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalNetwork").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGlobalNetworkRequest).withMarshaller((Marshaller)new UpdateGlobalNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateLinkResponse updateLink(UpdateLinkRequest updateLinkRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLinkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateLinkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLink").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLinkRequest).withMarshaller((Marshaller)new UpdateLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateSiteResponse updateSite(UpdateSiteRequest updateSiteRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, NetworkManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSiteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateSiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSite").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSiteRequest).withMarshaller((Marshaller)new UpdateSiteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NetworkManagerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends NetworkManagerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.15").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NetworkManagerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

