/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information about a VPC endpoint association, returned by <code>ListVpcEndpointAssociations</code>. You
 * can use the information provided in the metadata to retrieve and manage a VPC endpoint association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpointAssociationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEndpointAssociationMetadata.Builder, VpcEndpointAssociationMetadata> {
    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationArn").getter(getter(VpcEndpointAssociationMetadata::vpcEndpointAssociationArn))
            .setter(setter(Builder::vpcEndpointAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_ENDPOINT_ASSOCIATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointAssociationArn;

    private VpcEndpointAssociationMetadata(BuilderImpl builder) {
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a VPC endpoint association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a VPC endpoint association.
     */
    public final String vpcEndpointAssociationArn() {
        return vpcEndpointAssociationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociationMetadata)) {
            return false;
        }
        VpcEndpointAssociationMetadata other = (VpcEndpointAssociationMetadata) obj;
        return Objects.equals(vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpointAssociationMetadata").add("VpcEndpointAssociationArn", vpcEndpointAssociationArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointAssociationArn":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociationMetadata, T> g) {
        return obj -> g.apply((VpcEndpointAssociationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpointAssociationMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a VPC endpoint association.
         * </p>
         * 
         * @param vpcEndpointAssociationArn
         *        The Amazon Resource Name (ARN) of a VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointAssociationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociationMetadata model) {
            vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
        }

        public final String getVpcEndpointAssociationArn() {
            return vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        @Override
        public VpcEndpointAssociationMetadata build() {
            return new VpcEndpointAssociationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
