/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyRuleRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateProxyRuleRequest.Builder, UpdateProxyRuleRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(UpdateProxyRuleRequest::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupArn").getter(getter(UpdateProxyRuleRequest::proxyRuleGroupArn))
            .setter(setter(Builder::proxyRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()).build();

    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleName").getter(getter(UpdateProxyRuleRequest::proxyRuleName))
            .setter(setter(Builder::proxyRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateProxyRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(UpdateProxyRuleRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<ProxyRuleCondition>> ADD_CONDITIONS_FIELD = SdkField
            .<List<ProxyRuleCondition>> builder(MarshallingType.LIST)
            .memberName("AddConditions")
            .getter(getter(UpdateProxyRuleRequest::addConditions))
            .setter(setter(Builder::addConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProxyRuleCondition>> REMOVE_CONDITIONS_FIELD = SdkField
            .<List<ProxyRuleCondition>> builder(MarshallingType.LIST)
            .memberName("RemoveConditions")
            .getter(getter(UpdateProxyRuleRequest::removeConditions))
            .setter(setter(Builder::removeConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyRuleRequest::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD,
            PROXY_RULE_GROUP_ARN_FIELD, PROXY_RULE_NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, ADD_CONDITIONS_FIELD,
            REMOVE_CONDITIONS_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyRuleGroupName;

    private final String proxyRuleGroupArn;

    private final String proxyRuleName;

    private final String description;

    private final String action;

    private final List<ProxyRuleCondition> addConditions;

    private final List<ProxyRuleCondition> removeConditions;

    private final String updateToken;

    private UpdateProxyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.proxyRuleName = builder.proxyRuleName;
        this.description = builder.description;
        this.action = builder.action;
        this.addConditions = builder.addConditions;
        this.removeConditions = builder.removeConditions;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy rule group.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy rule group.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupArn() {
        return proxyRuleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     */
    public final String proxyRuleName() {
        return proxyRuleName;
    }

    /**
     * <p>
     * A description of the proxy rule.
     * </p>
     * 
     * @return A description of the proxy rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow or deny),
     * or continues it (if the action is alert) until it matches a rule with a terminal action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow
     *         or deny), or continues it (if the action is alert) until it matches a rule with a terminal action.
     * @see ProxyRulePhaseAction
     */
    public final ProxyRulePhaseAction action() {
        return ProxyRulePhaseAction.fromValue(action);
    }

    /**
     * <p>
     * Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow or deny),
     * or continues it (if the action is alert) until it matches a rule with a terminal action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow
     *         or deny), or continues it (if the action is alert) until it matches a rule with a terminal action.
     * @see ProxyRulePhaseAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddConditions() {
        return addConditions != null && !(addConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine. Conditions include
     * operators (StringEquals, StringLike) and values to match against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddConditions} method.
     * </p>
     * 
     * @return Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine. Conditions
     *         include operators (StringEquals, StringLike) and values to match against.
     */
    public final List<ProxyRuleCondition> addConditions() {
        return addConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveConditions() {
        return removeConditions != null && !(removeConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine. Conditions
     * include operators (StringEquals, StringLike) and values to match against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveConditions} method.
     * </p>
     * 
     * @return Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine.
     *         Conditions include operators (StringEquals, StringLike) and values to match against.
     */
    public final List<ProxyRuleCondition> removeConditions() {
        return removeConditions;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * rule. The token marks the state of the proxy rule resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
     * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
     * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current copy
     * of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
     *         <p>
     *         To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token
     *         to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
     *         operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
     *         again to get a current copy of it with a current token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddConditions() ? addConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveConditions() ? removeConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleRequest)) {
            return false;
        }
        UpdateProxyRuleRequest other = (UpdateProxyRuleRequest) obj;
        return Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName())
                && Objects.equals(proxyRuleGroupArn(), other.proxyRuleGroupArn())
                && Objects.equals(proxyRuleName(), other.proxyRuleName()) && Objects.equals(description(), other.description())
                && Objects.equals(actionAsString(), other.actionAsString()) && hasAddConditions() == other.hasAddConditions()
                && Objects.equals(addConditions(), other.addConditions()) && hasRemoveConditions() == other.hasRemoveConditions()
                && Objects.equals(removeConditions(), other.removeConditions())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyRuleRequest").add("ProxyRuleGroupName", proxyRuleGroupName())
                .add("ProxyRuleGroupArn", proxyRuleGroupArn()).add("ProxyRuleName", proxyRuleName())
                .add("Description", description()).add("Action", actionAsString())
                .add("AddConditions", hasAddConditions() ? addConditions() : null)
                .add("RemoveConditions", hasRemoveConditions() ? removeConditions() : null).add("UpdateToken", updateToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "ProxyRuleGroupArn":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupArn()));
        case "ProxyRuleName":
            return Optional.ofNullable(clazz.cast(proxyRuleName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "AddConditions":
            return Optional.ofNullable(clazz.cast(addConditions()));
        case "RemoveConditions":
            return Optional.ofNullable(clazz.cast(removeConditions()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("AddConditions", ADD_CONDITIONS_FIELD);
        map.put("RemoveConditions", REMOVE_CONDITIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleRequest, T> g) {
        return obj -> g.apply((UpdateProxyRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProxyRuleRequest> {
        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy rule group.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupArn
         *        The Amazon Resource Name (ARN) of a proxy rule group.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupArn(String proxyRuleGroupArn);

        /**
         * <p>
         * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * </p>
         * 
         * @param proxyRuleName
         *        The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleName(String proxyRuleName);

        /**
         * <p>
         * A description of the proxy rule.
         * </p>
         * 
         * @param description
         *        A description of the proxy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow or
         * deny), or continues it (if the action is alert) until it matches a rule with a terminal action.
         * </p>
         * 
         * @param action
         *        Depending on the match action, the proxy either stops the evaluation (if the action is terminal -
         *        allow or deny), or continues it (if the action is alert) until it matches a rule with a terminal
         *        action.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder action(String action);

        /**
         * <p>
         * Depending on the match action, the proxy either stops the evaluation (if the action is terminal - allow or
         * deny), or continues it (if the action is alert) until it matches a rule with a terminal action.
         * </p>
         * 
         * @param action
         *        Depending on the match action, the proxy either stops the evaluation (if the action is terminal -
         *        allow or deny), or continues it (if the action is alert) until it matches a rule with a terminal
         *        action.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder action(ProxyRulePhaseAction action);

        /**
         * <p>
         * Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * 
         * @param addConditions
         *        Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine.
         *        Conditions include operators (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addConditions(Collection<ProxyRuleCondition> addConditions);

        /**
         * <p>
         * Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * 
         * @param addConditions
         *        Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine.
         *        Conditions include operators (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addConditions(ProxyRuleCondition... addConditions);

        /**
         * <p>
         * Proxy rule conditions to add. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #addConditions(List<ProxyRuleCondition>)}.
         * 
         * @param addConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addConditions(java.util.Collection<ProxyRuleCondition>)
         */
        Builder addConditions(Consumer<ProxyRuleCondition.Builder>... addConditions);

        /**
         * <p>
         * Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * 
         * @param removeConditions
         *        Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine.
         *        Conditions include operators (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeConditions(Collection<ProxyRuleCondition> removeConditions);

        /**
         * <p>
         * Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * 
         * @param removeConditions
         *        Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine.
         *        Conditions include operators (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeConditions(ProxyRuleCondition... removeConditions);

        /**
         * <p>
         * Proxy rule conditions to remove. Match criteria that specify what traffic attributes to examine. Conditions
         * include operators (StringEquals, StringLike) and values to match against.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #removeConditions(List<ProxyRuleCondition>)}.
         * 
         * @param removeConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeConditions(java.util.Collection<ProxyRuleCondition>)
         */
        Builder removeConditions(Consumer<ProxyRuleCondition.Builder>... removeConditions);

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * rule. The token marks the state of the proxy rule resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
         * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current
         * copy of it with a current token. Reapply your changes as needed, then try the operation again using the new
         * token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
         *        <p>
         *        To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the
         *        token to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
         *        operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
         *        again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         *        operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyRuleGroupName;

        private String proxyRuleGroupArn;

        private String proxyRuleName;

        private String description;

        private String action;

        private List<ProxyRuleCondition> addConditions = DefaultSdkAutoConstructList.getInstance();

        private List<ProxyRuleCondition> removeConditions = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleRequest model) {
            super(model);
            proxyRuleGroupName(model.proxyRuleGroupName);
            proxyRuleGroupArn(model.proxyRuleGroupArn);
            proxyRuleName(model.proxyRuleName);
            description(model.description);
            action(model.action);
            addConditions(model.addConditions);
            removeConditions(model.removeConditions);
            updateToken(model.updateToken);
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getProxyRuleName() {
            return proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProxyRulePhaseAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getAddConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.addConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddConditions(Collection<ProxyRuleCondition.BuilderImpl> addConditions) {
            this.addConditions = ProxyRuleConditionListCopier.copyFromBuilder(addConditions);
        }

        @Override
        public final Builder addConditions(Collection<ProxyRuleCondition> addConditions) {
            this.addConditions = ProxyRuleConditionListCopier.copy(addConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addConditions(ProxyRuleCondition... addConditions) {
            addConditions(Arrays.asList(addConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addConditions(Consumer<ProxyRuleCondition.Builder>... addConditions) {
            addConditions(Stream.of(addConditions).map(c -> ProxyRuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getRemoveConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.removeConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveConditions(Collection<ProxyRuleCondition.BuilderImpl> removeConditions) {
            this.removeConditions = ProxyRuleConditionListCopier.copyFromBuilder(removeConditions);
        }

        @Override
        public final Builder removeConditions(Collection<ProxyRuleCondition> removeConditions) {
            this.removeConditions = ProxyRuleConditionListCopier.copy(removeConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeConditions(ProxyRuleCondition... removeConditions) {
            removeConditions(Arrays.asList(removeConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeConditions(Consumer<ProxyRuleCondition.Builder>... removeConditions) {
            removeConditions(Stream.of(removeConditions).map(c -> ProxyRuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyRuleRequest build() {
            return new UpdateProxyRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
