/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyRulePrioritiesResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<UpdateProxyRulePrioritiesResponse.Builder, UpdateProxyRulePrioritiesResponse> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(UpdateProxyRulePrioritiesResponse::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupArn").getter(getter(UpdateProxyRulePrioritiesResponse::proxyRuleGroupArn))
            .setter(setter(Builder::proxyRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_REQUEST_PHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupRequestPhase").getter(getter(UpdateProxyRulePrioritiesResponse::ruleGroupRequestPhaseAsString))
            .setter(setter(Builder::ruleGroupRequestPhase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRequestPhase").build())
            .build();

    private static final SdkField<List<ProxyRulePriority>> RULES_FIELD = SdkField
            .<List<ProxyRulePriority>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(UpdateProxyRulePrioritiesResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRulePriority> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRulePriority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyRulePrioritiesResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD,
            PROXY_RULE_GROUP_ARN_FIELD, RULE_GROUP_REQUEST_PHASE_FIELD, RULES_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyRuleGroupName;

    private final String proxyRuleGroupArn;

    private final String ruleGroupRequestPhase;

    private final List<ProxyRulePriority> rules;

    private final String updateToken;

    private UpdateProxyRulePrioritiesResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.ruleGroupRequestPhase = builder.ruleGroupRequestPhase;
        this.rules = builder.rules;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy rule group.
     */
    public final String proxyRuleGroupArn() {
        return proxyRuleGroupArn;
    }

    /**
     * <p>
     * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
     * match is applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleGroupRequestPhase} will return {@link RuleGroupRequestPhase#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ruleGroupRequestPhaseAsString}.
     * </p>
     * 
     * @return Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where
     *         the rule match is applied.
     * @see RuleGroupRequestPhase
     */
    public final RuleGroupRequestPhase ruleGroupRequestPhase() {
        return RuleGroupRequestPhase.fromValue(ruleGroupRequestPhase);
    }

    /**
     * <p>
     * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
     * match is applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleGroupRequestPhase} will return {@link RuleGroupRequestPhase#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ruleGroupRequestPhaseAsString}.
     * </p>
     * 
     * @return Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where
     *         the rule match is applied.
     * @see RuleGroupRequestPhase
     */
    public final String ruleGroupRequestPhaseAsString() {
        return ruleGroupRequestPhase;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated proxy rule hierarchy that reflects the updates from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The updated proxy rule hierarchy that reflects the updates from the request.
     */
    public final List<ProxyRulePriority> rules() {
        return rules;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy rule
     * group. The token marks the state of the proxy rule group resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy rule group, you provide the token in your request. Network Firewall uses the token
     * to ensure that the proxy rule group hasn't changed since you last retrieved it. If it has changed, the operation
     * fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule group again to get a
     * current copy of it with a current token. Reapply your changes as needed, then try the operation again using the
     * new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy rule group. The token marks the state of the proxy rule group resource at the time of the request.
     *         </p>
     *         <p>
     *         To make changes to the proxy rule group, you provide the token in your request. Network Firewall uses the
     *         token to ensure that the proxy rule group hasn't changed since you last retrieved it. If it has changed,
     *         the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
     *         group again to get a current copy of it with a current token. Reapply your changes as needed, then try
     *         the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupRequestPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRulePrioritiesResponse)) {
            return false;
        }
        UpdateProxyRulePrioritiesResponse other = (UpdateProxyRulePrioritiesResponse) obj;
        return Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName())
                && Objects.equals(proxyRuleGroupArn(), other.proxyRuleGroupArn())
                && Objects.equals(ruleGroupRequestPhaseAsString(), other.ruleGroupRequestPhaseAsString())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyRulePrioritiesResponse").add("ProxyRuleGroupName", proxyRuleGroupName())
                .add("ProxyRuleGroupArn", proxyRuleGroupArn()).add("RuleGroupRequestPhase", ruleGroupRequestPhaseAsString())
                .add("Rules", hasRules() ? rules() : null).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "ProxyRuleGroupArn":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupArn()));
        case "RuleGroupRequestPhase":
            return Optional.ofNullable(clazz.cast(ruleGroupRequestPhaseAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("RuleGroupRequestPhase", RULE_GROUP_REQUEST_PHASE_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRulePrioritiesResponse, T> g) {
        return obj -> g.apply((UpdateProxyRulePrioritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProxyRulePrioritiesResponse> {
        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy rule group.
         * </p>
         * 
         * @param proxyRuleGroupArn
         *        The Amazon Resource Name (ARN) of a proxy rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupArn(String proxyRuleGroupArn);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * 
         * @param ruleGroupRequestPhase
         *        Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic
         *        where the rule match is applied.
         * @see RuleGroupRequestPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupRequestPhase
         */
        Builder ruleGroupRequestPhase(String ruleGroupRequestPhase);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * 
         * @param ruleGroupRequestPhase
         *        Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic
         *        where the rule match is applied.
         * @see RuleGroupRequestPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupRequestPhase
         */
        Builder ruleGroupRequestPhase(RuleGroupRequestPhase ruleGroupRequestPhase);

        /**
         * <p>
         * The updated proxy rule hierarchy that reflects the updates from the request.
         * </p>
         * 
         * @param rules
         *        The updated proxy rule hierarchy that reflects the updates from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ProxyRulePriority> rules);

        /**
         * <p>
         * The updated proxy rule hierarchy that reflects the updates from the request.
         * </p>
         * 
         * @param rules
         *        The updated proxy rule hierarchy that reflects the updates from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ProxyRulePriority... rules);

        /**
         * <p>
         * The updated proxy rule hierarchy that reflects the updates from the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriority.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriority.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<ProxyRulePriority>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRulePriority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<ProxyRulePriority>)
         */
        Builder rules(Consumer<ProxyRulePriority.Builder>... rules);

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * rule group. The token marks the state of the proxy rule group resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy rule group, you provide the token in your request. Network Firewall uses the
         * token to ensure that the proxy rule group hasn't changed since you last retrieved it. If it has changed, the
         * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule group
         * again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         * operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy rule group. The token marks the state of the proxy rule group resource at the time of the
         *        request. </p>
         *        <p>
         *        To make changes to the proxy rule group, you provide the token in your request. Network Firewall uses
         *        the token to ensure that the proxy rule group hasn't changed since you last retrieved it. If it has
         *        changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
         *        proxy rule group again to get a current copy of it with a current token. Reapply your changes as
         *        needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String proxyRuleGroupName;

        private String proxyRuleGroupArn;

        private String ruleGroupRequestPhase;

        private List<ProxyRulePriority> rules = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRulePrioritiesResponse model) {
            super(model);
            proxyRuleGroupName(model.proxyRuleGroupName);
            proxyRuleGroupArn(model.proxyRuleGroupArn);
            ruleGroupRequestPhase(model.ruleGroupRequestPhase);
            rules(model.rules);
            updateToken(model.updateToken);
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getRuleGroupRequestPhase() {
            return ruleGroupRequestPhase;
        }

        public final void setRuleGroupRequestPhase(String ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase = ruleGroupRequestPhase;
        }

        @Override
        public final Builder ruleGroupRequestPhase(String ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase = ruleGroupRequestPhase;
            return this;
        }

        @Override
        public final Builder ruleGroupRequestPhase(RuleGroupRequestPhase ruleGroupRequestPhase) {
            this.ruleGroupRequestPhase(ruleGroupRequestPhase == null ? null : ruleGroupRequestPhase.toString());
            return this;
        }

        public final List<ProxyRulePriority.Builder> getRules() {
            List<ProxyRulePriority.Builder> result = ProxyRulePriorityListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ProxyRulePriority.BuilderImpl> rules) {
            this.rules = ProxyRulePriorityListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ProxyRulePriority> rules) {
            this.rules = ProxyRulePriorityListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ProxyRulePriority... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ProxyRulePriority.Builder>... rules) {
            rules(Stream.of(rules).map(c -> ProxyRulePriority.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateProxyRulePrioritiesResponse build() {
            return new UpdateProxyRulePrioritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
