/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyRuleGroupPrioritiesResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<UpdateProxyRuleGroupPrioritiesResponse.Builder, UpdateProxyRuleGroupPrioritiesResponse> {
    private static final SdkField<List<ProxyRuleGroupPriorityResult>> PROXY_RULE_GROUPS_FIELD = SdkField
            .<List<ProxyRuleGroupPriorityResult>> builder(MarshallingType.LIST)
            .memberName("ProxyRuleGroups")
            .getter(getter(UpdateProxyRuleGroupPrioritiesResponse::proxyRuleGroups))
            .setter(setter(Builder::proxyRuleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRuleGroupPriorityResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRuleGroupPriorityResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyRuleGroupPrioritiesResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUPS_FIELD,
            UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProxyRuleGroupPriorityResult> proxyRuleGroups;

    private final String updateToken;

    private UpdateProxyRuleGroupPrioritiesResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroups = builder.proxyRuleGroups;
        this.updateToken = builder.updateToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProxyRuleGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProxyRuleGroups() {
        return proxyRuleGroups != null && !(proxyRuleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated proxy rule group hierarchy that reflects the updates from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProxyRuleGroups} method.
     * </p>
     * 
     * @return The updated proxy rule group hierarchy that reflects the updates from the request.
     */
    public final List<ProxyRuleGroupPriorityResult> proxyRuleGroups() {
        return proxyRuleGroups;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * configuration. The token marks the state of the proxy configuration resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
     * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed, the
     * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy configuration
     * again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation
     * again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy configuration. The token marks the state of the proxy configuration resource at the time of the
     *         request. </p>
     *         <p>
     *         To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses
     *         the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has
     *         changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
     *         proxy configuration again to get a current copy of it with a current token. Reapply your changes as
     *         needed, then try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProxyRuleGroups() ? proxyRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleGroupPrioritiesResponse)) {
            return false;
        }
        UpdateProxyRuleGroupPrioritiesResponse other = (UpdateProxyRuleGroupPrioritiesResponse) obj;
        return hasProxyRuleGroups() == other.hasProxyRuleGroups() && Objects.equals(proxyRuleGroups(), other.proxyRuleGroups())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyRuleGroupPrioritiesResponse")
                .add("ProxyRuleGroups", hasProxyRuleGroups() ? proxyRuleGroups() : null).add("UpdateToken", updateToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroups":
            return Optional.ofNullable(clazz.cast(proxyRuleGroups()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroups", PROXY_RULE_GROUPS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleGroupPrioritiesResponse, T> g) {
        return obj -> g.apply((UpdateProxyRuleGroupPrioritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProxyRuleGroupPrioritiesResponse> {
        /**
         * <p>
         * The updated proxy rule group hierarchy that reflects the updates from the request.
         * </p>
         * 
         * @param proxyRuleGroups
         *        The updated proxy rule group hierarchy that reflects the updates from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroups(Collection<ProxyRuleGroupPriorityResult> proxyRuleGroups);

        /**
         * <p>
         * The updated proxy rule group hierarchy that reflects the updates from the request.
         * </p>
         * 
         * @param proxyRuleGroups
         *        The updated proxy rule group hierarchy that reflects the updates from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroups(ProxyRuleGroupPriorityResult... proxyRuleGroups);

        /**
         * <p>
         * The updated proxy rule group hierarchy that reflects the updates from the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResult.Builder#build()} is
         * called immediately and its result is passed to {@link #proxyRuleGroups(List<ProxyRuleGroupPriorityResult>)}.
         * 
         * @param proxyRuleGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyRuleGroups(java.util.Collection<ProxyRuleGroupPriorityResult>)
         */
        Builder proxyRuleGroups(Consumer<ProxyRuleGroupPriorityResult.Builder>... proxyRuleGroups);

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * configuration. The token marks the state of the proxy configuration resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
         * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed,
         * the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy
         * configuration again to get a current copy of it with a current token. Reapply your changes as needed, then
         * try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy configuration. The token marks the state of the proxy configuration resource at the time of the
         *        request. </p>
         *        <p>
         *        To make changes to the proxy configuration, you provide the token in your request. Network Firewall
         *        uses the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If
         *        it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens,
         *        retrieve the proxy configuration again to get a current copy of it with a current token. Reapply your
         *        changes as needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private List<ProxyRuleGroupPriorityResult> proxyRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleGroupPrioritiesResponse model) {
            super(model);
            proxyRuleGroups(model.proxyRuleGroups);
            updateToken(model.updateToken);
        }

        public final List<ProxyRuleGroupPriorityResult.Builder> getProxyRuleGroups() {
            List<ProxyRuleGroupPriorityResult.Builder> result = ProxyRuleGroupPriorityResultListCopier
                    .copyToBuilder(this.proxyRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxyRuleGroups(Collection<ProxyRuleGroupPriorityResult.BuilderImpl> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupPriorityResultListCopier.copyFromBuilder(proxyRuleGroups);
        }

        @Override
        public final Builder proxyRuleGroups(Collection<ProxyRuleGroupPriorityResult> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupPriorityResultListCopier.copy(proxyRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(ProxyRuleGroupPriorityResult... proxyRuleGroups) {
            proxyRuleGroups(Arrays.asList(proxyRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(Consumer<ProxyRuleGroupPriorityResult.Builder>... proxyRuleGroups) {
            proxyRuleGroups(Stream.of(proxyRuleGroups).map(c -> ProxyRuleGroupPriorityResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateProxyRuleGroupPrioritiesResponse build() {
            return new UpdateProxyRuleGroupPrioritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
