/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateProxyRequest.Builder, UpdateProxyRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId").getter(getter(UpdateProxyRequest::natGatewayId)).setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").build()).build();

    private static final SdkField<String> PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyName").getter(getter(UpdateProxyRequest::proxyName)).setter(setter(Builder::proxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyName").build()).build();

    private static final SdkField<String> PROXY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyArn").getter(getter(UpdateProxyRequest::proxyArn)).setter(setter(Builder::proxyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyArn").build()).build();

    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_TO_ADD_FIELD = SdkField
            .<List<ListenerPropertyRequest>> builder(MarshallingType.LIST)
            .memberName("ListenerPropertiesToAdd")
            .getter(getter(UpdateProxyRequest::listenerPropertiesToAdd))
            .setter(setter(Builder::listenerPropertiesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerPropertiesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerPropertyRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerPropertyRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListenerPropertyRequest>> LISTENER_PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<ListenerPropertyRequest>> builder(MarshallingType.LIST)
            .memberName("ListenerPropertiesToRemove")
            .getter(getter(UpdateProxyRequest::listenerPropertiesToRemove))
            .setter(setter(Builder::listenerPropertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerPropertiesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerPropertyRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerPropertyRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TlsInterceptPropertiesRequest> TLS_INTERCEPT_PROPERTIES_FIELD = SdkField
            .<TlsInterceptPropertiesRequest> builder(MarshallingType.SDK_POJO).memberName("TlsInterceptProperties")
            .getter(getter(UpdateProxyRequest::tlsInterceptProperties)).setter(setter(Builder::tlsInterceptProperties))
            .constructor(TlsInterceptPropertiesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptProperties").build())
            .build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyRequest::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD,
            PROXY_NAME_FIELD, PROXY_ARN_FIELD, LISTENER_PROPERTIES_TO_ADD_FIELD, LISTENER_PROPERTIES_TO_REMOVE_FIELD,
            TLS_INTERCEPT_PROPERTIES_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String natGatewayId;

    private final String proxyName;

    private final String proxyArn;

    private final List<ListenerPropertyRequest> listenerPropertiesToAdd;

    private final List<ListenerPropertyRequest> listenerPropertiesToRemove;

    private final TlsInterceptPropertiesRequest tlsInterceptProperties;

    private final String updateToken;

    private UpdateProxyRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.proxyName = builder.proxyName;
        this.proxyArn = builder.proxyArn;
        this.listenerPropertiesToAdd = builder.listenerPropertiesToAdd;
        this.listenerPropertiesToRemove = builder.listenerPropertiesToRemove;
        this.tlsInterceptProperties = builder.tlsInterceptProperties;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The NAT Gateway the proxy is attached to.
     * </p>
     * 
     * @return The NAT Gateway the proxy is attached to.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy. You can't change the name of a proxy after you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyName() {
        return proxyName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyArn() {
        return proxyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerPropertiesToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListenerPropertiesToAdd() {
        return listenerPropertiesToAdd != null && !(listenerPropertiesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Listener properties for HTTP and HTTPS traffic to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerPropertiesToAdd} method.
     * </p>
     * 
     * @return Listener properties for HTTP and HTTPS traffic to add.
     */
    public final List<ListenerPropertyRequest> listenerPropertiesToAdd() {
        return listenerPropertiesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerPropertiesToRemove property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListenerPropertiesToRemove() {
        return listenerPropertiesToRemove != null && !(listenerPropertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Listener properties for HTTP and HTTPS traffic to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerPropertiesToRemove} method.
     * </p>
     * 
     * @return Listener properties for HTTP and HTTPS traffic to remove.
     */
    public final List<ListenerPropertyRequest> listenerPropertiesToRemove() {
        return listenerPropertiesToRemove;
    }

    /**
     * <p>
     * TLS decryption on traffic to filter on attributes in the HTTP header.
     * </p>
     * 
     * @return TLS decryption on traffic to filter on attributes in the HTTP header.
     */
    public final TlsInterceptPropertiesRequest tlsInterceptProperties() {
        return tlsInterceptProperties;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy. The
     * token marks the state of the proxy resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to ensure
     * that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails with an
     * <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current copy of it with a
     * current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy. The token marks the state of the proxy resource at the time of the request. </p>
     *         <p>
     *         To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to
     *         ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails
     *         with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current
     *         copy of it with a current token. Reapply your changes as needed, then try the operation again using the
     *         new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proxyName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerPropertiesToAdd() ? listenerPropertiesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerPropertiesToRemove() ? listenerPropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tlsInterceptProperties());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRequest)) {
            return false;
        }
        UpdateProxyRequest other = (UpdateProxyRequest) obj;
        return Objects.equals(natGatewayId(), other.natGatewayId()) && Objects.equals(proxyName(), other.proxyName())
                && Objects.equals(proxyArn(), other.proxyArn())
                && hasListenerPropertiesToAdd() == other.hasListenerPropertiesToAdd()
                && Objects.equals(listenerPropertiesToAdd(), other.listenerPropertiesToAdd())
                && hasListenerPropertiesToRemove() == other.hasListenerPropertiesToRemove()
                && Objects.equals(listenerPropertiesToRemove(), other.listenerPropertiesToRemove())
                && Objects.equals(tlsInterceptProperties(), other.tlsInterceptProperties())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyRequest").add("NatGatewayId", natGatewayId()).add("ProxyName", proxyName())
                .add("ProxyArn", proxyArn())
                .add("ListenerPropertiesToAdd", hasListenerPropertiesToAdd() ? listenerPropertiesToAdd() : null)
                .add("ListenerPropertiesToRemove", hasListenerPropertiesToRemove() ? listenerPropertiesToRemove() : null)
                .add("TlsInterceptProperties", tlsInterceptProperties()).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "ProxyName":
            return Optional.ofNullable(clazz.cast(proxyName()));
        case "ProxyArn":
            return Optional.ofNullable(clazz.cast(proxyArn()));
        case "ListenerPropertiesToAdd":
            return Optional.ofNullable(clazz.cast(listenerPropertiesToAdd()));
        case "ListenerPropertiesToRemove":
            return Optional.ofNullable(clazz.cast(listenerPropertiesToRemove()));
        case "TlsInterceptProperties":
            return Optional.ofNullable(clazz.cast(tlsInterceptProperties()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("ProxyName", PROXY_NAME_FIELD);
        map.put("ProxyArn", PROXY_ARN_FIELD);
        map.put("ListenerPropertiesToAdd", LISTENER_PROPERTIES_TO_ADD_FIELD);
        map.put("ListenerPropertiesToRemove", LISTENER_PROPERTIES_TO_REMOVE_FIELD);
        map.put("TlsInterceptProperties", TLS_INTERCEPT_PROPERTIES_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRequest, T> g) {
        return obj -> g.apply((UpdateProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProxyRequest> {
        /**
         * <p>
         * The NAT Gateway the proxy is attached to.
         * </p>
         * 
         * @param natGatewayId
         *        The NAT Gateway the proxy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The descriptive name of the proxy. You can't change the name of a proxy after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyName
         *        The descriptive name of the proxy. You can't change the name of a proxy after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyName(String proxyName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyArn
         *        The Amazon Resource Name (ARN) of a proxy.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyArn(String proxyArn);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to add.
         * </p>
         * 
         * @param listenerPropertiesToAdd
         *        Listener properties for HTTP and HTTPS traffic to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPropertiesToAdd(Collection<ListenerPropertyRequest> listenerPropertiesToAdd);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to add.
         * </p>
         * 
         * @param listenerPropertiesToAdd
         *        Listener properties for HTTP and HTTPS traffic to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPropertiesToAdd(ListenerPropertyRequest... listenerPropertiesToAdd);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #listenerPropertiesToAdd(List<ListenerPropertyRequest>)}.
         * 
         * @param listenerPropertiesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerPropertiesToAdd(java.util.Collection<ListenerPropertyRequest>)
         */
        Builder listenerPropertiesToAdd(Consumer<ListenerPropertyRequest.Builder>... listenerPropertiesToAdd);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to remove.
         * </p>
         * 
         * @param listenerPropertiesToRemove
         *        Listener properties for HTTP and HTTPS traffic to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPropertiesToRemove(Collection<ListenerPropertyRequest> listenerPropertiesToRemove);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to remove.
         * </p>
         * 
         * @param listenerPropertiesToRemove
         *        Listener properties for HTTP and HTTPS traffic to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPropertiesToRemove(ListenerPropertyRequest... listenerPropertiesToRemove);

        /**
         * <p>
         * Listener properties for HTTP and HTTPS traffic to remove.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #listenerPropertiesToRemove(List<ListenerPropertyRequest>)}.
         * 
         * @param listenerPropertiesToRemove
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ListenerPropertyRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerPropertiesToRemove(java.util.Collection<ListenerPropertyRequest>)
         */
        Builder listenerPropertiesToRemove(Consumer<ListenerPropertyRequest.Builder>... listenerPropertiesToRemove);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * 
         * @param tlsInterceptProperties
         *        TLS decryption on traffic to filter on attributes in the HTTP header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties);

        /**
         * <p>
         * TLS decryption on traffic to filter on attributes in the HTTP header.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsInterceptPropertiesRequest.Builder}
         * avoiding the need to create one manually via {@link TlsInterceptPropertiesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsInterceptPropertiesRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsInterceptProperties(TlsInterceptPropertiesRequest)}.
         * 
         * @param tlsInterceptProperties
         *        a consumer that will call methods on {@link TlsInterceptPropertiesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInterceptProperties(TlsInterceptPropertiesRequest)
         */
        default Builder tlsInterceptProperties(Consumer<TlsInterceptPropertiesRequest.Builder> tlsInterceptProperties) {
            return tlsInterceptProperties(TlsInterceptPropertiesRequest.builder().applyMutation(tlsInterceptProperties).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy.
         * The token marks the state of the proxy resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy, you provide the token in your request. Network Firewall uses the token to
         * ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation fails with
         * an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a current copy of it
         * with a current token. Reapply your changes as needed, then try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy. The token marks the state of the proxy resource at the time of the request. </p>
         *        <p>
         *        To make changes to the proxy, you provide the token in your request. Network Firewall uses the token
         *        to ensure that the proxy hasn't changed since you last retrieved it. If it has changed, the operation
         *        fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy again to get a
         *        current copy of it with a current token. Reapply your changes as needed, then try the operation again
         *        using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String natGatewayId;

        private String proxyName;

        private String proxyArn;

        private List<ListenerPropertyRequest> listenerPropertiesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<ListenerPropertyRequest> listenerPropertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private TlsInterceptPropertiesRequest tlsInterceptProperties;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRequest model) {
            super(model);
            natGatewayId(model.natGatewayId);
            proxyName(model.proxyName);
            proxyArn(model.proxyArn);
            listenerPropertiesToAdd(model.listenerPropertiesToAdd);
            listenerPropertiesToRemove(model.listenerPropertiesToRemove);
            tlsInterceptProperties(model.tlsInterceptProperties);
            updateToken(model.updateToken);
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getProxyName() {
            return proxyName;
        }

        public final void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public final Builder proxyName(String proxyName) {
            this.proxyName = proxyName;
            return this;
        }

        public final String getProxyArn() {
            return proxyArn;
        }

        public final void setProxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
        }

        @Override
        public final Builder proxyArn(String proxyArn) {
            this.proxyArn = proxyArn;
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerPropertiesToAdd() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier
                    .copyToBuilder(this.listenerPropertiesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerPropertiesToAdd(Collection<ListenerPropertyRequest.BuilderImpl> listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd = ListenerPropertiesRequestCopier.copyFromBuilder(listenerPropertiesToAdd);
        }

        @Override
        public final Builder listenerPropertiesToAdd(Collection<ListenerPropertyRequest> listenerPropertiesToAdd) {
            this.listenerPropertiesToAdd = ListenerPropertiesRequestCopier.copy(listenerPropertiesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToAdd(ListenerPropertyRequest... listenerPropertiesToAdd) {
            listenerPropertiesToAdd(Arrays.asList(listenerPropertiesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToAdd(Consumer<ListenerPropertyRequest.Builder>... listenerPropertiesToAdd) {
            listenerPropertiesToAdd(Stream.of(listenerPropertiesToAdd)
                    .map(c -> ListenerPropertyRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListenerPropertyRequest.Builder> getListenerPropertiesToRemove() {
            List<ListenerPropertyRequest.Builder> result = ListenerPropertiesRequestCopier
                    .copyToBuilder(this.listenerPropertiesToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerPropertiesToRemove(Collection<ListenerPropertyRequest.BuilderImpl> listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove = ListenerPropertiesRequestCopier.copyFromBuilder(listenerPropertiesToRemove);
        }

        @Override
        public final Builder listenerPropertiesToRemove(Collection<ListenerPropertyRequest> listenerPropertiesToRemove) {
            this.listenerPropertiesToRemove = ListenerPropertiesRequestCopier.copy(listenerPropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToRemove(ListenerPropertyRequest... listenerPropertiesToRemove) {
            listenerPropertiesToRemove(Arrays.asList(listenerPropertiesToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPropertiesToRemove(Consumer<ListenerPropertyRequest.Builder>... listenerPropertiesToRemove) {
            listenerPropertiesToRemove(Stream.of(listenerPropertiesToRemove)
                    .map(c -> ListenerPropertyRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsInterceptPropertiesRequest.Builder getTlsInterceptProperties() {
            return tlsInterceptProperties != null ? tlsInterceptProperties.toBuilder() : null;
        }

        public final void setTlsInterceptProperties(TlsInterceptPropertiesRequest.BuilderImpl tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties != null ? tlsInterceptProperties.build() : null;
        }

        @Override
        public final Builder tlsInterceptProperties(TlsInterceptPropertiesRequest tlsInterceptProperties) {
            this.tlsInterceptProperties = tlsInterceptProperties;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyRequest build() {
            return new UpdateProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
