/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateProxyConfigurationRequest.Builder, UpdateProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName").getter(getter(UpdateProxyConfigurationRequest::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationArn").getter(getter(UpdateProxyConfigurationRequest::proxyConfigurationArn))
            .setter(setter(Builder::proxyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build())
            .build();

    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField
            .<ProxyConfigDefaultRulePhaseActionsRequest> builder(MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions")
            .getter(getter(UpdateProxyConfigurationRequest::defaultRulePhaseActions))
            .setter(setter(Builder::defaultRulePhaseActions)).constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build())
            .build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyConfigurationRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, DEFAULT_RULE_PHASE_ACTIONS_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyConfigurationName;

    private final String proxyConfigurationArn;

    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

    private final String updateToken;

    private UpdateProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy configuration.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy configuration.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyConfigurationArn() {
        return proxyConfigurationArn;
    }

    /**
     * <p>
     * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
     * match is applied.
     * </p>
     * 
     * @return Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where
     *         the rule match is applied.
     */
    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return defaultRulePhaseActions;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * configuration. The token marks the state of the proxy configuration resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
     * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed, the
     * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy configuration
     * again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation
     * again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy configuration. The token marks the state of the proxy configuration resource at the time of the
     *         request. </p>
     *         <p>
     *         To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses
     *         the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has
     *         changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
     *         proxy configuration again to get a current copy of it with a current token. Reapply your changes as
     *         needed, then try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyConfigurationRequest)) {
            return false;
        }
        UpdateProxyConfigurationRequest other = (UpdateProxyConfigurationRequest) obj;
        return Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(proxyConfigurationArn(), other.proxyConfigurationArn())
                && Objects.equals(defaultRulePhaseActions(), other.defaultRulePhaseActions())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyConfigurationRequest").add("ProxyConfigurationName", proxyConfigurationName())
                .add("ProxyConfigurationArn", proxyConfigurationArn()).add("DefaultRulePhaseActions", defaultRulePhaseActions())
                .add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "ProxyConfigurationArn":
            return Optional.ofNullable(clazz.cast(proxyConfigurationArn()));
        case "DefaultRulePhaseActions":
            return Optional.ofNullable(clazz.cast(defaultRulePhaseActions()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateProxyConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProxyConfigurationRequest> {
        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy configuration.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyConfigurationArn
         *        The Amazon Resource Name (ARN) of a proxy configuration.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationArn(String proxyConfigurationArn);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * 
         * @param defaultRulePhaseActions
         *        Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic
         *        where the rule match is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder} avoiding the need to create one manually via
         * {@link ProxyConfigDefaultRulePhaseActionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)}.
         * 
         * @param defaultRulePhaseActions
         *        a consumer that will call methods on {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)
         */
        default Builder defaultRulePhaseActions(
                Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.builder()
                    .applyMutation(defaultRulePhaseActions).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * configuration. The token marks the state of the proxy configuration resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy configuration, you provide the token in your request. Network Firewall uses the
         * token to ensure that the proxy configuration hasn't changed since you last retrieved it. If it has changed,
         * the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy
         * configuration again to get a current copy of it with a current token. Reapply your changes as needed, then
         * try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy configuration. The token marks the state of the proxy configuration resource at the time of the
         *        request. </p>
         *        <p>
         *        To make changes to the proxy configuration, you provide the token in your request. Network Firewall
         *        uses the token to ensure that the proxy configuration hasn't changed since you last retrieved it. If
         *        it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens,
         *        retrieve the proxy configuration again to get a current copy of it with a current token. Reapply your
         *        changes as needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyConfigurationName;

        private String proxyConfigurationArn;

        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyConfigurationRequest model) {
            super(model);
            proxyConfigurationName(model.proxyConfigurationName);
            proxyConfigurationArn(model.proxyConfigurationArn);
            defaultRulePhaseActions(model.defaultRulePhaseActions);
            updateToken(model.updateToken);
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return defaultRulePhaseActions != null ? defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyConfigurationRequest build() {
            return new UpdateProxyConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
